package ru.yandex.qe.dispenser.ws.job;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.distributed.DistributedManager;

@DisallowConcurrentExecution
public class DistributedManagerUpdateJob extends AbstractJobWithHierarchy {

    private static final Logger LOG = LoggerFactory.getLogger(DistributedManagerUpdateJob.class);

    private DistributedManager distributedManager;

    public DistributedManagerUpdateJob() {
        super(LOG);
    }

    @Autowired
    public void setDistributedManager(final DistributedManager distributedManager) {
        this.distributedManager = distributedManager;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        distributedManager.update();
    }

}
