package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.history.HistoryClearTask;
import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

public abstract class HistoryClearJob<T extends HistoryClearTask> extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryClearJob.class);

    private T historyClearTask;

    protected HistoryClearJob() {
        super(LOG);
    }

    @Inject
    public void setHistoryClearTask(final T historyClearTask) {
        this.historyClearTask = historyClearTask;
    }

    @Override
    public void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        try {
            historyClearTask.clear();
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            LOG.error("Unable to clear history in task '" + historyClearTask.getName() + "'", e);
            throw new JobExecutionException(e);
        }
    }
}
