package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.quota.QuotaMaxAggregationJob;

@DisallowConcurrentExecution
public class MaxAggregationJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(MaxAggregationJob.class);

    private QuotaMaxAggregationJob quotaMaxAggregationTask;

    public MaxAggregationJob() {
        super(LOG);
    }

    @Inject
    public void setQuotaMaxAggregationTask(final QuotaMaxAggregationJob quotaMaxAggregationTask) {
        this.quotaMaxAggregationTask = quotaMaxAggregationTask;
    }

    @Override
    protected void executeWithHierarchy(JobExecutionContext context) throws JobExecutionException {
        quotaMaxAggregationTask.aggregateMaxes();
    }
}
