package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.entity.EntityLifetimeManager;

@DisallowConcurrentExecution
public class RemoveOldEntityJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveOldEntityJob.class);

    private EntityLifetimeManager entityLifetimeManager;

    public RemoveOldEntityJob() {
        super(LOG);
    }

    @Inject
    public void setEntityLifetimeManager(final EntityLifetimeManager entityLifetimeManager) {
        this.entityLifetimeManager = entityLifetimeManager;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        entityLifetimeManager.removeOld();
    }
}
