package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.request.RequestManager;

@DisallowConcurrentExecution
public class RemoveOldIdempotentRequestsJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveOldIdempotentRequestsJob.class);

    private RequestManager requestManager;

    public RemoveOldIdempotentRequestsJob() {
        super(LOG);
    }

    @Inject
    public void setRequestManager(final RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        requestManager.removeOld();
    }
}
