package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.notifications.NotificationManager;

@DisallowConcurrentExecution
public class SendNotificationsJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(SendNotificationsJob.class);

    private NotificationManager notificationManager;

    public SendNotificationsJob() {
        super(LOG);
    }

    @Inject
    public void setNotificationManager(final NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        notificationManager.sendNotifications();
    }
}
