package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.ServicesOverCommitValueMetrics;

@DisallowConcurrentExecution
public class ServiceOverCommitMetricsJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceOverCommitMetricsJob.class);

    private ServicesOverCommitValueMetrics task;

    public ServiceOverCommitMetricsJob() {
        super(LOG);
    }

    @Inject
    public void setTask(final ServicesOverCommitValueMetrics task) {
        this.task = task;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        task.countOverCommit();
    }
}
