package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.lots.LotsManager;

@DisallowConcurrentExecution
public class UpdateLastOverQuotingTsJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLastOverQuotingTsJob.class);

    private LotsManager lotsManager;

    public UpdateLastOverQuotingTsJob() {
        super(LOG);
    }

    @Inject
    public void setLotsManager(final LotsManager lotsManager) {
        this.lotsManager = lotsManager;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        lotsManager.update();
    }
}
