package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.abc.UpdateProjectMembers;

@DisallowConcurrentExecution
public class UpdateProjectMembersJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProjectMembersJob.class);

    private UpdateProjectMembers updateProjectMembers;

    public UpdateProjectMembersJob() {
        super(LOG);
    }

    @Inject
    public void setUpdateProjectMembers(final UpdateProjectMembers updateProjectMembers) {
        this.updateProjectMembers = updateProjectMembers;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        updateProjectMembers.update();
    }
}
