package ru.yandex.qe.dispenser.ws.param;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.dao.bot.settings.BotCampaignGroupDao;

import javax.ws.rs.ext.Provider;

@Provider
public class BotCampaignGroupConverterProvider extends ConverterProviderBase<BotCampaignGroup> {

    @Autowired
    private BotCampaignGroupDao botCampaignGroupDao;

    protected BotCampaignGroupConverterProvider() {
        super(BotCampaignGroup.class);
    }

    @Override
    public BotCampaignGroup fromString(String value) {
        return botCampaignGroupDao.read(Long.valueOf(value));
    }

    @Override
    public String toString(BotCampaignGroup value) {
        return String.valueOf(value.getId());
    }
}
