package ru.yandex.qe.dispenser.ws.param;

import java.util.function.Supplier;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public abstract class ComplexParam<T> implements Supplier<T> {
    @NotNull
    protected Resource resource(@NotNull final Service service, @NotNull final String resourceKey) {
        return Hierarchy.get().getResourceReader().read(new Resource.Key(resourceKey, service));
    }

    @NotNull
    protected QuotaSpec quotaSpec(@NotNull final Service service, @NotNull final String resourceKey, @NotNull final String quotaSpecKey) {
        return Hierarchy.get().getQuotaSpecReader().read(new QuotaSpec.Key(quotaSpecKey, resource(service, resourceKey)));
    }
}
