package ru.yandex.qe.dispenser.ws.param;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

import org.jetbrains.annotations.NotNull;
import org.springframework.dao.EmptyResultDataAccessException;

public abstract class ConverterProviderBase<T> implements ParamConverterProvider, ParamConverter<T> {
    @NotNull
    private final Class<T> objClass;

    protected ConverterProviderBase(@NotNull final Class<T> objClass) {
        this.objClass = objClass;
    }

    @Override
    public <R> ParamConverter<R> getConverter(@NotNull final Class<R> rawType,
                                              @NotNull final Type genericType,
                                              @NotNull final Annotation[] annotations) {
        //noinspection unchecked
        return !objClass.equals(rawType) ? null : (ParamConverter<R>) new ParamConverter<T>() {
            @NotNull
            @Override
            public T fromString(@NotNull final String key) {
                try {
                    return ConverterProviderBase.this.fromString(key);
                } catch (EmptyResultDataAccessException e) {
                    throw new NotFoundException(e.getMessage(), e.getCause());
                }
            }

            @NotNull
            @Override
            public String toString(@NotNull final T obj) {
                return ConverterProviderBase.this.toString(obj);
            }
        };
    }
}
