package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.entity.EntityDao;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.domain.util.ApplicationContextProvider;
import ru.yandex.qe.dispenser.ws.EntityService;
import ru.yandex.qe.dispenser.ws.EntitySpecService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public final class EntityParam extends ComplexParam<Entity> {
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(EntitySpecService.ENTITY_SPEC_KEY)
    private String entitySpecKey;
    @PathParam(EntityService.ENTITY_KEY)
    private String entityKey;

    public EntityParam(final Service service, final String entitySpecKey, final String entityKey) {
        this.service = service;
        this.entitySpecKey = entitySpecKey;
        this.entityKey = entityKey;
    }

    @Override
    public Entity get() {
        final EntityDao entityDao = ApplicationContextProvider.getContext().getBean(EntityDao.class);
        final EntitySpec spec = Hierarchy.get().getEntitySpecReader().read(new EntitySpec.Key(entitySpecKey, service));
        return entityDao.read(new Entity.Key(entityKey, spec));
    }
}
