package ru.yandex.qe.dispenser.ws.param;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.dao.entity.spec.EntitySpecUtils;

public class EntitySpecFilterParam extends ComplexParam<EntitySpec> {
    @NotNull
    private final EntitySpec spec;

    public EntitySpecFilterParam(@NotNull final String serciceEntitySpecKey) {
        final String[] parts = serciceEntitySpecKey.split("/");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Expected: &resource key: /{serviceKey}/{entitySpecKey}, found: " + serciceEntitySpecKey);
        }
        spec = EntitySpecUtils.toEntitySpec(parts[1], parts[2]);
    }

    @NotNull
    @Override
    public EntitySpec get() {
        return spec;
    }
}
