package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.ws.EntitySpecService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public final class EntitySpecParam extends ComplexParam<EntitySpec> {
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(EntitySpecService.ENTITY_SPEC_KEY)
    private String entitySpecKey;

    public EntitySpecParam(final Service service, final String entitySpecKey) {
        this.service = service;
        this.entitySpecKey = entitySpecKey;
    }

    @NotNull
    @Override
    public EntitySpec get() {
        return Hierarchy.get().getEntitySpecReader().read(new EntitySpec.Key(entitySpecKey, service));
    }
}
