package ru.yandex.qe.dispenser.ws.param;

import java.time.Instant;
import java.util.Set;

import javax.ws.rs.QueryParam;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.dao.history.HistoryFilter;
import ru.yandex.qe.dispenser.domain.util.DateTimeUtils;
import ru.yandex.qe.dispenser.ws.history.HistoryFilterImpl;

public class HistoryParams {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String PERFORMER = "performer";
    public static final String TVM_ID = "tvmId";

    @QueryParam(FROM)
    protected Instant from;

    @QueryParam(TO)
    protected Instant to;

    @QueryParam(PERFORMER)
    protected Set<Person> performers;

    @QueryParam(TVM_ID)
    protected Set<Long> tvmIds;

    public HistoryParams(final String from, final String to, final Set<Person> performers, final Set<Long> tvmIds) {
        this.from = from != null ? DateTimeUtils.parse(from) : null;
        this.to = to != null ? DateTimeUtils.parse(to) : null;
        this.performers = performers;
        this.tvmIds = tvmIds;
    }

    public HistoryFilter toHistoryFilter() {
        return new HistoryFilterImpl(from, to, performers, tvmIds);
    }
}
