package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.BeanParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

public class PaginationParam {
    @BeanParam
    private PageParam pageParam;
    @Context
    private UriInfo uriInfo;

    public static PaginationParam from(final Long page, final Long pageSize, final Long limit, final UriInfo uriInfo) {
        PaginationParam res = new PaginationParam();
        res.uriInfo = uriInfo;
        res.pageParam = new PageParam(page, pageSize, limit);
        return res;
    }

    public PageParam getPageParam() {
        return pageParam;
    }

    public UriInfo getUriInfo() {
        return uriInfo;
    }
}
