package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.ext.Provider;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

@Provider
public final class PersonConverterProvider extends StringKeyConverterProvider<Person> {
    public PersonConverterProvider() {
        super(Person.class);
    }

    @NotNull
    @Override
    public Person fromString(@NotNull final String login) {
        return Hierarchy.get().getPersonReader().readPersonByLogin(login);
    }
}
