package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectDao;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.ws.ServiceBase;

@Provider
public final class ProjectConverterProvider extends ConverterProviderBase<Project> {

    @Context
    private UriInfo uriInfo;

    @Autowired
    private ProjectDao projectDao;

    public ProjectConverterProvider() {
        super(Project.class);
    }

    @NotNull
    @Override
    public Project fromString(final String key) {
        if (Boolean.TRUE.toString().equals(uriInfo.getQueryParameters().getFirst(ServiceBase.NO_CACHE))) {
            return projectDao.read(key);
        }
        return Hierarchy.get().getProjectReader().readExisting(key);
    }

    @NotNull
    @Override
    public String toString(@NotNull final Project value) {
        return value.getPublicKey();
    }
}
