package ru.yandex.qe.dispenser.ws.param;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.dao.quota.request.QuotaChangeRequestDao;

public class QuotaChangeRequestConverterProvider extends ConverterProviderBase<QuotaChangeRequest> {
    @Autowired
    private QuotaChangeRequestDao quotaChangeRequestDao;

    protected QuotaChangeRequestConverterProvider() {
        super(QuotaChangeRequest.class);
    }

    @Override
    public QuotaChangeRequest fromString(final String value) {
        return quotaChangeRequestDao.read(Long.valueOf(value));
    }

    @Override
    public String toString(final QuotaChangeRequest value) {
        return String.valueOf(value.getId());
    }
}
