package ru.yandex.qe.dispenser.ws.param;

import java.util.Set;

import javax.ws.rs.QueryParam;

import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestImportantFilter;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestSortField;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestUnbalancedFilter;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;
import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.quota.request.QuotaChangeRequestReader;

public class QuotaChangeRequestFilterParam {
    public static final String PROJECT_PARAM = "project";
    public static final String AUTHOR_PARAM = "author";
    public static final String STATUS_PARAM = "status";
    public static final String ABC_SERVICE_ID_PARAM = "abcServiceId";
    public static final String ANCESTOR_ABC_SERVICE_ID_PARAM = "ancestorAbcServiceId";
    public static final String TYPE_PARAM = "type";
    public static final String SERVICE_PARAM = "service";
    public static final String ORDER_PARAM = "order";
    public static final String CAMPAIGN_PARAM = "campaign";
    public static final String CAMPAIGN_ORDER_PARAM = "campaignOrder";
    public static final String RESOURCE_PREORDER_REASON_TYPE_PARAM = "resourcePreorderReasonType";
    public static final String GOAL_PARAM = "goal";
    public static final String PRE_ORDER_PARAM = "preOrderId";
    public static final String SORT_ORDER = "sortOrder";
    public static final String SORT_BY = "sortBy";
    public static final String SUMMARY_PARAM = "summary";
    public static final String RESPONSIBLE_PARAM = "responsible";
    public static final String OWNING_COST_GREATER_OR_EQUALS_PARAM = "owningCostGreaterOrEquals";
    public static final String OWNING_COST_LESS_OR_EQUALS_PARAM = "owningCostLessOrEquals";
    private static final String IMPORTANT_FILTER_PARAM = "importantFilter";
    private static final String UNBALANCED_FILTER_PARAM = "unbalancedFilter";
    private static final String CAMPAIGN_TYPES_FILTER_PARAM = "campaignTypes";

    @QueryParam(PROJECT_PARAM)
    private Set<String> projectKeys;

    @QueryParam(AUTHOR_PARAM)
    private Set<String> authors;

    @QueryParam(STATUS_PARAM)
    private Set<DiQuotaChangeRequest.Status> status;

    @QueryParam(ABC_SERVICE_ID_PARAM)
    private Set<Integer> abcServiceIds;

    @QueryParam(ANCESTOR_ABC_SERVICE_ID_PARAM)
    private Set<Integer> ancestorAbcServiceId;

    @QueryParam(TYPE_PARAM)
    private Set<DiQuotaChangeRequest.Type> type;

    @QueryParam(SERVICE_PARAM)
    private Set<Service> services;

    @QueryParam(ORDER_PARAM)
    private Set<Long> orderIds;
    @QueryParam(CAMPAIGN_PARAM)
    private Set<Long> campaignIds;
    @QueryParam(CAMPAIGN_ORDER_PARAM)
    private Set<Long> campaignOrderIds;

    @QueryParam(RESOURCE_PREORDER_REASON_TYPE_PARAM)
    private Set<DiResourcePreorderReasonType> reasonTypes;

    @QueryParam(GOAL_PARAM)
    private Set<Long> goalsIds;

    @QueryParam(PRE_ORDER_PARAM)
    private Set<Long> preOrderIds;

    @QueryParam(SORT_ORDER)
    private QuotaChangeRequestReader.SortOrder sortOrder;

    @QueryParam(SORT_BY)
    private DiQuotaChangeRequestSortField sortBy;

    @QueryParam(SUMMARY_PARAM)
    @Nullable
    private String summary;

    @QueryParam(RESPONSIBLE_PARAM)
    private Set<String> responsible;

    @QueryParam(OWNING_COST_GREATER_OR_EQUALS_PARAM)
    private Long owningCostGreaterOrEquals;

    @QueryParam(OWNING_COST_LESS_OR_EQUALS_PARAM)
    private Long owningCostLessOrEquals;

    @QueryParam(IMPORTANT_FILTER_PARAM)
    private DiQuotaChangeRequestImportantFilter importantFilter;

    @QueryParam(UNBALANCED_FILTER_PARAM)
    private DiQuotaChangeRequestUnbalancedFilter unbalancedFilter;

    @QueryParam(CAMPAIGN_TYPES_FILTER_PARAM)
    private Set<Campaign.Type> campaignTypes;


    public Set<String> getProjectKeys() {
        return projectKeys;
    }

    public Set<String> getAuthors() {
        return authors;
    }

    public Set<DiQuotaChangeRequest.Status> getStatus() {
        return status;
    }

    public Set<Integer> getAbcServiceIds() {
        return abcServiceIds;
    }

    public Set<Integer> getAncestorAbcServiceId() {
        return ancestorAbcServiceId;
    }

    public Set<DiQuotaChangeRequest.Type> getType() {
        return type;
    }

    public Set<Service> getServices() {
        return services;
    }

    public Set<Long> getOrderIds() {
        return orderIds;
    }

    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    public Set<Long> getCampaignOrderIds() {
        return campaignOrderIds;
    }

    public Set<DiResourcePreorderReasonType> getReasonTypes() {
        return reasonTypes;
    }

    public Set<Long> getGoalsIds() {
        return goalsIds;
    }

    public Set<Long> getPreOrderIds() {
        return preOrderIds;
    }

    @Nullable
    public QuotaChangeRequestReader.SortOrder getSortOrder() {
        return sortOrder;
    }

    @Nullable
    public DiQuotaChangeRequestSortField getSortBy() {
        return sortBy;
    }

    @Nullable
    public String getSummary() {
        return summary;
    }

    public Set<String> getResponsible() {
        return responsible;
    }

    @Nullable
    public Long getOwningCostGreaterOrEquals() {
        return owningCostGreaterOrEquals;
    }

    @Nullable
    public Long getOwningCostLessOrEquals() {
        return owningCostLessOrEquals;
    }

    @Nullable
    public DiQuotaChangeRequestImportantFilter getImportantFilter() {
        return importantFilter;
    }

    @Nullable
    public DiQuotaChangeRequestUnbalancedFilter getUnbalancedFilter() {
        return unbalancedFilter;
    }

    @Nullable
    public Set<Campaign.Type> getCampaignTypes() {
        return campaignTypes;
    }

}
