package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.ws.ProjectService;
import ru.yandex.qe.dispenser.ws.QuotaSpecService;
import ru.yandex.qe.dispenser.ws.ServiceResourceService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public final class QuotaKeyParam extends ComplexParam<Quota.Key> {
    @PathParam(ProjectService.PROJECT_KEY)
    private Project project;
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(ServiceResourceService.RESOURCE_KEY)
    private String resourceKey;
    @PathParam(QuotaSpecService.QUOTA_SPEC_KEY)
    private String quotaSpecKey;

    public QuotaKeyParam(final Project project, final Service service, final String resourceKey, final String quotaSpecKey) {
        this.project = project;
        this.service = service;
        this.resourceKey = resourceKey;
        this.quotaSpecKey = quotaSpecKey;
    }

    @Override
    public @NotNull Quota.Key get() {
        return Quota.Key.totalOf(quotaSpec(service, resourceKey, quotaSpecKey), project);
    }
}
