package ru.yandex.qe.dispenser.ws.param;

import java.util.Set;

import javax.ws.rs.QueryParam;

import ru.yandex.qe.dispenser.api.v1.DiQuotaRequestHistoryEventType;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.dao.history.request.QuotaChangeRequestHistoryFilter;
import ru.yandex.qe.dispenser.ws.history.QuotaChangeRequestHistoryFilterImpl;

public class QuotaRequestHistoryParams extends HistoryParams {
    public static final String EVENT_TYPE = "eventType";

    @QueryParam(EVENT_TYPE)
    private Set<DiQuotaRequestHistoryEventType> eventTypes;

    public QuotaRequestHistoryParams(final String from,
                                     final String to,
                                     final Set<Person> performers,
                                     final Set<Long> tvmIds,
                                     final Set<DiQuotaRequestHistoryEventType> eventTypes) {
        super(from, to, performers, tvmIds);
        this.eventTypes = eventTypes;
    }

    @Override
    public QuotaChangeRequestHistoryFilter toHistoryFilter() {
        return new QuotaChangeRequestHistoryFilterImpl(from, to, performers, tvmIds, eventTypes);
    }
}
