package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.ws.QuotaSpecService;
import ru.yandex.qe.dispenser.ws.ServiceResourceService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public final class QuotaSpecParam extends ComplexParam<QuotaSpec> {
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(ServiceResourceService.RESOURCE_KEY)
    private String resourceKey;
    @PathParam(QuotaSpecService.QUOTA_SPEC_KEY)
    private String quotaSpecKey;

    public QuotaSpecParam(final Service service, final String resourceKey, final String quotaSpecKey) {
        this.service = service;
        this.resourceKey = resourceKey;
        this.quotaSpecKey = quotaSpecKey;
    }

    @NotNull
    @Override
    public QuotaSpec get() {
        return quotaSpec(service, resourceKey, quotaSpecKey);
    }
}
