package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

import ru.yandex.qe.dispenser.api.util.NumberUtils;
import ru.yandex.qe.dispenser.api.v1.DiOrder;

public class RelativePageParam {
    public static final String PAGE_SIZE = "pageSize";
    public static final String FROM_ID = "fromId";
    public static final String PAGE_ORDER = "pageOrder";
    public static final String DEFAULT_PAGE_SIZE = "100";
    public static final Long DEFAULT_PAGE_SIZE_LONG = Long.parseLong(DEFAULT_PAGE_SIZE);
    public static final String DEFAULT_FROM_ID = "0";
    public static final String DEFAULT_ORDER = "ASC";

    @QueryParam(PAGE_SIZE)
    @DefaultValue(DEFAULT_PAGE_SIZE)
    private Long pageSize;

    @QueryParam(FROM_ID)
    private Long fromId;

    @QueryParam(PAGE_ORDER)
    @DefaultValue(DEFAULT_ORDER)
    private DiOrder order;

    @Context
    private UriInfo uriInfo;

    public RelativePageParam(final Long pageSize, final Long fromId, final UriInfo uriInfo, final DiOrder order) {
        if (pageSize != null) {
            this.pageSize = NumberUtils.requirePositive(pageSize, "pageSize");
        } else {
            this.pageSize = DEFAULT_PAGE_SIZE_LONG;
        }
        if (fromId == null) {
            if (order == DiOrder.DESC) {
                this.fromId = Long.MAX_VALUE;
            } else {
                this.fromId = 0L;
            }
        } else {
            this.fromId = fromId;
        }
        this.uriInfo = uriInfo;
        this.order = order;
    }

    public Long getPageSize() {
        return pageSize;
    }

    public Long getFromId() {
        return fromId;
    }

    public UriInfo getUriInfo() {
        return uriInfo;
    }

    public DiOrder getOrder() {
        return order;
    }
}
