package ru.yandex.qe.dispenser.ws.param;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public final class ResourceFilterParam extends ComplexParam<Resource> {
    @NotNull
    private final Resource resource;

    public ResourceFilterParam(@NotNull final String serciceResourceKey) {
        final String[] parts = serciceResourceKey.split("/");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Expected: &resource key: /{serviceKey}/{resourceKey}, found: " + serciceResourceKey);
        }
        final Service service = Hierarchy.get().getServiceReader().read(parts[1]);
        resource = resource(service, parts[2]);
    }

    @NotNull
    @Override
    public Resource get() {
        return resource;
    }
}
