package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.ResourceGroup;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.ws.ResourceGroupService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public class ResourceGroupParam {
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(ResourceGroupService.RESOURCE_GROUP_KEY)
    private String resourceGroupKey;

    public ResourceGroupParam(final Service service, final String resourceGroupKey) {
        this.service = service;
        this.resourceGroupKey = resourceGroupKey;
    }

    @NotNull
    public ResourceGroup get() {
        return Hierarchy.get().getResourceGroupReader().read(new ResourceGroup.Key(resourceGroupKey, service));
    }
}
