package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.ws.ServiceResourceService;
import ru.yandex.qe.dispenser.ws.ServiceService;

public final class ResourceParam extends ComplexParam<Resource> {
    @PathParam(ServiceService.SERVICE_KEY)
    private Service service;
    @PathParam(ServiceResourceService.RESOURCE_KEY)
    private String resourceKey;

    public ResourceParam(final Service service, final String resourceKey) {
        this.service = service;
        this.resourceKey = resourceKey;
    }

    @Override
    public @NotNull Resource get() {
        return resource(service, resourceKey);
    }
}
