package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.PathParam;

import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.ws.SegmentService;
import ru.yandex.qe.dispenser.ws.SegmentationService;

public class SegmentParam extends ComplexParam<Segment> {
    @PathParam(SegmentationService.SEGMENTATION_KEY)
    private Segmentation segmentation;
    @PathParam(SegmentService.SEGMENT_KEY)
    private String segmentKey;

    public SegmentParam(final Segmentation segmentation, final String segmentKey) {
        this.segmentation = segmentation;
        this.segmentKey = segmentKey;
    }

    @Override
    public Segment get() {
        return Hierarchy.get().getSegmentReader().read(new Segment.Key(segmentKey, segmentation));
    }
}
