package ru.yandex.qe.dispenser.ws.param;

import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public class SegmentationConverterProvider extends ConverterProviderBase<Segmentation> {
    protected SegmentationConverterProvider() {
        super(Segmentation.class);
    }

    @Override
    public Segmentation fromString(final String key) {
        return Hierarchy.get().getSegmentationReader().read(new Segmentation.Key(key));

    }

    @Override
    public String toString(final Segmentation segmentation) {
        return segmentation.getKey().getPublicKey();
    }
}
