package ru.yandex.qe.dispenser.ws.param;

import javax.ws.rs.ext.Provider;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

@Provider
public final class ServiceConverterProvider extends StringKeyConverterProvider<Service> {
    public ServiceConverterProvider() {
        super(Service.class);
    }

    @NotNull
    @Override
    public Service fromString(@NotNull final String key) {
        return Hierarchy.get().getServiceReader().read(key);
    }
}
