package ru.yandex.qe.dispenser.ws.param;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.Keyable;

public abstract class StringKeyConverterProvider<T extends Keyable<String>> extends ConverterProviderBase<T> {
    protected StringKeyConverterProvider(@NotNull final Class<T> keyableClass) {
        super(keyableClass);
    }

    @NotNull
    @Override
    public String toString(@NotNull final T keyable) {
        return keyable.getKey();
    }
}
