package ru.yandex.qe.dispenser.ws.param;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.util.SerializationUtils;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

@Provider
public final class UserMessageBodyReader implements MessageBodyReader<List<Person>> {
    @Override
    public boolean isReadable(@NotNull final Class<?> type,
                              @NotNull final Type genericType,
                              @NotNull final Annotation[] annotations,
                              @NotNull final MediaType mediaType) {
        return type.equals(List.class) && ((ParameterizedType) genericType).getActualTypeArguments()[0].equals(Person.class);
    }

    @Override
    public List<Person> readFrom(@NotNull final Class<List<Person>> type,
                                 @NotNull final Type genericType,
                                 @NotNull final Annotation[] annotations,
                                 @NotNull final MediaType mediaType,
                                 @NotNull final MultivaluedMap<String, String> httpHeaders,
                                 @NotNull final InputStream entityStream) throws WebApplicationException {
        try {
            return Arrays.stream(SerializationUtils.readValue(entityStream, String[].class))
                    .map(Hierarchy.get().getPersonReader()::readPersonByLogin)
                    .collect(Collectors.toList());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}
