package ru.yandex.qe.dispenser.ws.quota.request;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Segment;

public final class ChangeComparator implements Comparator<QuotaChangeRequest.Change> {
    public static final ChangeComparator INSTANCE = new ChangeComparator();

    private ChangeComparator() {
    }

    @Override
    public int compare(final QuotaChangeRequest.Change o1, final QuotaChangeRequest.Change o2) {
        final Resource resource1 = o1.getResource();
        final Resource resource2 = o2.getResource();
        if (!resource1.equals(resource2)) {
            return resource1.compareTo(resource2);
        }
        final List<Segment.Key> segmentKeyList1 = o1.getSegments().stream().map(Segment::getKey).sorted().collect(Collectors.toList());
        final List<Segment.Key> segmentKeyList2 = o2.getSegments().stream().map(Segment::getKey).sorted().collect(Collectors.toList());
        for (int i = 0; i < Math.min(segmentKeyList1.size(), segmentKeyList2.size()); i++) {
            final Segment.Key key1 = segmentKeyList1.get(i);
            final Segment.Key key2 = segmentKeyList2.get(i);
            if (!key1.equals(key2)) {
                return key1.compareTo(key2);
            }
        }
        if (segmentKeyList1.size() != segmentKeyList2.size()) {
            return segmentKeyList1.size() - segmentKeyList2.size();
        }
        return Long.compare(o1.getAmount(), o2.getAmount());
    }
}
