package ru.yandex.qe.dispenser.ws.quota.request;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.ws.job.AbstractJobWithHierarchy;

@DisallowConcurrentExecution
public class ReCreateRequestTicketsJob extends AbstractJobWithHierarchy {

    private static final Logger LOG = LoggerFactory.getLogger(ReCreateRequestTicketsJob.class);

    public ReCreateRequestTicketsJob() {
        super(LOG);
    }

    private ReCreateRequestTicketsTask reCreateRequestTicketsTask;

    @Autowired
    public void setReCreateRequestTicketsTask(final ReCreateRequestTicketsTask reCreateRequestTicketsTask) {
        this.reCreateRequestTicketsTask = reCreateRequestTicketsTask;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        reCreateRequestTicketsTask.createTickets();
    }
}
