package ru.yandex.qe.dispenser.ws.quota.request.owning_cost;

import java.util.Objects;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

/**
 * Quota request change with context for calculate owning cost.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class ChangeOwningCostContext {
    private final QuotaChangeRequest.Change change;
    private final int abcServiceId;
    private final QuotaChangeRequest.Campaign campaign;

    private ChangeOwningCostContext(QuotaChangeRequest.Change change, int abcServiceId,
                                    QuotaChangeRequest.Campaign campaign) {
        this.change = change;
        this.abcServiceId = abcServiceId;
        this.campaign = campaign;
    }

    public QuotaChangeRequest.Change getChange() {
        return change;
    }

    public int getAbcServiceId() {
        return abcServiceId;
    }

    public QuotaChangeRequest.Campaign getCampaign() {
        return campaign;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangeOwningCostContext that = (ChangeOwningCostContext) o;
        return abcServiceId == that.abcServiceId && Objects.equals(change, that.change) && Objects.equals(campaign,
                that.campaign);
    }

    @Override
    public int hashCode() {
        return Objects.hash(change, abcServiceId, campaign);
    }

    @Override
    public String toString() {
        return "ChangeOwningCostContext{" +
                "change=" + change +
                ", abcServiceId=" + abcServiceId +
                ", campaign=" + campaign +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder copyBuilder() {
        return new Builder()
                .change(change)
                .abcServiceId(abcServiceId)
                .campaign(campaign);
    }

    public static class Builder {
        private QuotaChangeRequest.Change change;
        private Integer abcServiceId;
        private QuotaChangeRequest.Campaign campaign;

        public Builder change(QuotaChangeRequest.Change change) {
            this.change = change;
            return this;
        }

        public Builder abcServiceId(Integer abcServiceId) {
            this.abcServiceId = abcServiceId;
            return this;
        }

        public Builder abcServiceIdFromRequest(QuotaChangeRequest request) {
            this.abcServiceId = request.getProject().getAbcServiceId();
            return this;
        }

        public Builder campaign(QuotaChangeRequest.Campaign campaign) {
            this.campaign = campaign;
            return this;
        }

        public Builder campaignFromRequest(QuotaChangeRequest request) {
            return this.campaign(request.getCampaign());
        }

        public ChangeOwningCostContext build() {
            return new ChangeOwningCostContext(
                    Objects.requireNonNull(change),
                    Objects.requireNonNull(abcServiceId),
                    Objects.requireNonNull(campaign)
            );
        }
    }
}
