package ru.yandex.qe.dispenser.ws.quota.request.owning_cost;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

/**
 * Changes with owning cost for update owning cost.
 * Contains all changes from request in {@link this#changesWithCalculatedOwningCostForUpdateOwningCost} with updated owning costs
 * and list of changes from update request in  {@link this#changesWithCalculatedOwningCost} with calculated owning cost.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class ChangesWithOwningCostForUpdate {
    private final List<QuotaChangeRequest.Change> changesWithCalculatedOwningCost;
    private final Collection<QuotaChangeRequest.Change> changesWithCalculatedOwningCostForUpdateOwningCost;


    private ChangesWithOwningCostForUpdate(List<QuotaChangeRequest.Change> changesWithCalculatedOwningCost,
                                           Collection<QuotaChangeRequest.Change> changesWithCalculatedOwningCostForUpdateOwningCost) {
        this.changesWithCalculatedOwningCost = changesWithCalculatedOwningCost;
        this.changesWithCalculatedOwningCostForUpdateOwningCost = changesWithCalculatedOwningCostForUpdateOwningCost;
    }

    public List<QuotaChangeRequest.Change> getChangesWithCalculatedOwningCost() {
        return changesWithCalculatedOwningCost;
    }

    public Collection<QuotaChangeRequest.Change> getChangesWithCalculatedOwningCostForUpdateOwningCost() {
        return changesWithCalculatedOwningCostForUpdateOwningCost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangesWithOwningCostForUpdate that = (ChangesWithOwningCostForUpdate) o;
        return Objects.equals(changesWithCalculatedOwningCost, that.changesWithCalculatedOwningCost) && Objects.equals(changesWithCalculatedOwningCostForUpdateOwningCost, that.changesWithCalculatedOwningCostForUpdateOwningCost);
    }

    @Override
    public int hashCode() {
        return Objects.hash(changesWithCalculatedOwningCost, changesWithCalculatedOwningCostForUpdateOwningCost);
    }

    @Override
    public String toString() {
        return "ChangesWithOwningCostForUpdate{" +
                "changesWithCalculatedOwningCost=" + changesWithCalculatedOwningCost +
                ", changesWithCalculatedOwningCostForUpdateOwningCost=" + changesWithCalculatedOwningCostForUpdateOwningCost +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<QuotaChangeRequest.Change> changesWithCalculatedOwningCost;
        private Collection<QuotaChangeRequest.Change> changesWithCalculatedOwningCostForUpdateOwningCost;

        public Builder changesWithCalculatedOwningCost(List<QuotaChangeRequest.Change> changesWithCalculatedOwningCost) {
            this.changesWithCalculatedOwningCost = changesWithCalculatedOwningCost;
            return this;
        }

        public Builder changesWithCalculatedOwningCostForUpdateOwningCost(Collection<QuotaChangeRequest.Change> changesWithCalculatedOwningCostForUpdateOwningCost) {
            this.changesWithCalculatedOwningCostForUpdateOwningCost = changesWithCalculatedOwningCostForUpdateOwningCost;
            return this;
        }

        public ChangesWithOwningCostForUpdate build() {
            return new ChangesWithOwningCostForUpdate(
                    Objects.requireNonNull(changesWithCalculatedOwningCost),
                    Objects.requireNonNull(changesWithCalculatedOwningCostForUpdateOwningCost)
            );
        }
    }
}
