package ru.yandex.qe.dispenser.ws.quota.request.owning_cost;

import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pre_calculation_chain.PreCalculation;

import static ru.yandex.qe.dispenser.ws.quota.request.owning_cost.QuotaChangeOwningCostPreCalculationManager.State.FAIL;
import static ru.yandex.qe.dispenser.ws.quota.request.owning_cost.QuotaChangeOwningCostPreCalculationManager.State.SUCCESS;

/**
 * QuotaChangeOwningCostPreCalculationManager prepares quota changes for owning cost calculation.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class QuotaChangeOwningCostPreCalculationManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaChangeOwningCostPreCalculationManager.class);

    private final List<PreCalculation> preCalculations;

    public QuotaChangeOwningCostPreCalculationManager(List<PreCalculation> preCalculations) {
        this.preCalculations = preCalculations;
    }

    /**
     * Apply PreCalculation's on changes.
     *
     * @param quotaChangeRequestOwningCostContext with raw data from requests.
     * @return changes for calculation owning price
     */
    @NotNull
    public Tuple2<List<ChangeOwningCostContext>, State> apply(
            @NotNull QuotaChangeRequestOwningCostContext quotaChangeRequestOwningCostContext) {
        QuotaChangeRequestOwningCostContext result = quotaChangeRequestOwningCostContext;
        State state = SUCCESS;

        for (PreCalculation preCalculation : preCalculations) {
            try {
                result = preCalculation.apply(quotaChangeRequestOwningCostContext);
            } catch (Exception e) {
                state = FAIL;
                LOG.error("Error while preparing changes for calculation owning cost!", e);
            }
        }

        return Tuple2.tuple(result.getChangeOwningCostContexts(),
                state);
    }

    public enum State {
        SUCCESS,
        FAIL,
    }
}
