package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.campaignOwningCost;

import java.util.concurrent.TimeUnit;

import com.google.common.base.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.qe.dispenser.solomon.SolomonHolder;

@Component
@Profile("secondary")
public class CampaignOwningCostRefreshTask {
    private static final Logger LOG = LoggerFactory.getLogger(CampaignOwningCostRefreshTask.class);
    public static final String LAST_SUCCESS_SENSOR = "campaign_owning_cost_refresh_task.time_since_last_success_end";

    private final Ticker ticker = Ticker.systemTicker();
    private final CampaignOwningCostRefreshManager campaignOwningCostRefreshManager;

    private volatile long lastSuccessEnd;


    public CampaignOwningCostRefreshTask(CampaignOwningCostRefreshManager campaignOwningCostRefreshManager,
                                         SolomonHolder solomonHolder) {
        this.campaignOwningCostRefreshManager = campaignOwningCostRefreshManager;
        final MetricRegistry rootRegistry = solomonHolder.getRootRegistry();
        this.lastSuccessEnd = TimeUnit.NANOSECONDS.toMillis(ticker.read());
        rootRegistry.lazyGaugeInt64(LAST_SUCCESS_SENSOR, Labels.of(), () -> TimeUnit.NANOSECONDS.toMillis(ticker.read()) - lastSuccessEnd);
    }

    public void run() {
        LOG.info("Refreshing campaign owning cost...");
        boolean success = false;
        try {
            campaignOwningCostRefreshManager.refresh();
            success = true;
        } finally {
            if (success) {
                lastSuccessEnd = TimeUnit.NANOSECONDS.toMillis(ticker.read());
            }
        }
        LOG.info("Successfully refreshed campaign owning cost");
    }
}
