package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.formula;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

/**
 * Default provider owning cost formula.
 * Always return changes with
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class DefaultOwningCostFormula implements ProviderOwningCostFormula {
    @NotNull
    @Override
    public String getProviderKey() {
        return DEFAULT_FORMULA_KEY;
    }

    @NotNull
    @Override
    public Map<QuotaChangeRequest.ChangeKey, BigDecimal> calculateOwningCost(@NotNull Collection<QuotaChangeRequest.Change> changes) {
        Map<QuotaChangeRequest.ChangeKey, BigDecimal> result = new HashMap<>();
        changes.forEach(change -> result.put(change.getKey(), DEFAULT_OWNING_COST));
        return result;
    }
}
