package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pricing;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

/**
 * SKU model.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class PricingModel {
    private final String date;
    private final SKUProvider provider;
    private final String SKU;
    private final String SKUDescription;
    private final ResourceClass resourceClass;
    private final BigDecimal price;
    private final String pricingUnit;

    private PricingModel(String date, SKUProvider provider, String SKU, String SKUDescription,
                        ResourceClass resourceClass, BigDecimal price, String pricingUnit) {
        this.date = date;
        this.provider = provider;
        this.SKU = SKU;
        this.SKUDescription = SKUDescription;
        this.resourceClass = resourceClass;
        this.price = price;
        this.pricingUnit = pricingUnit;
    }

    public String getDate() {
        return date;
    }

    public SKUProvider getProvider() {
        return provider;
    }

    public String getSKU() {
        return SKU;
    }

    public String getSKUDescription() {
        return SKUDescription;
    }

    public ResourceClass getResourceClass() {
        return resourceClass;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public String getPricingUnit() {
        return pricingUnit;
    }

    @Override
    public String toString() {
        return "PricingModel{" +
                "date='" + date + '\'' +
                ", provider=" + provider +
                ", SKU='" + SKU + '\'' +
                ", SKUDescription='" + SKUDescription + '\'' +
                ", resourceClass=" + resourceClass +
                ", price=" + price +
                ", pricingUnit='" + pricingUnit + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PricingModel that = (PricingModel) o;
        return Objects.equals(date, that.date) && Objects.equals(provider, that.provider) && Objects.equals(SKU,
                that.SKU) && Objects.equals(SKUDescription, that.SKUDescription) && Objects.equals(resourceClass,
                that.resourceClass) && Objects.equals(price, that.price) && Objects.equals(pricingUnit,
                that.pricingUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, provider, SKU, SKUDescription, resourceClass, price, pricingUnit);
    }

    public BigDecimal add(PricingModel pricingModel, MathContext mathContext) {
        return this.price.add(pricingModel.price, mathContext);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String date;
        private SKUProvider provider;
        private String SKU;
        private String SKUDescription;
        private ResourceClass resourceClass;
        private BigDecimal price;
        private String pricingUnit;

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public Builder provider(SKUProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder SKU(String SKU) {
            this.SKU = SKU;
            return this;
        }

        public Builder SKUDescription(String SKUDescription) {
            this.SKUDescription = SKUDescription;
            return this;
        }

        public Builder resourceClass(ResourceClass resourceClass) {
            this.resourceClass = resourceClass;
            return this;
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder price(String price) {
            this.price = new BigDecimal(price);
            return this;
        }

        public Builder pricingUnit(String pricingUnit) {
            this.pricingUnit = pricingUnit;
            return this;
        }

        public PricingModel build() {
            return new PricingModel(
                    Objects.requireNonNull(date),
                    Objects.requireNonNull(provider),
                    Objects.requireNonNull(SKU),
                    Objects.requireNonNull(SKUDescription),
                    Objects.requireNonNull(resourceClass),
                    Objects.requireNonNull(price),
                    Objects.requireNonNull(pricingUnit)
            );
        }
    }
}
