package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pricing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.collect.ImmutableMap;

/**
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public enum ResourceClass {
    CPU("CPU"),
    GPU("GPU"),
    HDD("HDD"),
    NVME("NVMe"),
    NETWORK("Network"),
    RAM("RAM"),
    SSD("SSD"),
    STORAGE("Storage"),
    STORAGE_QUERYS("Storage.Querys"),
    UNKNOWN("UNKNOWN"),
    YT_DYNAMIC_TABLES("YT.Dynamic_Tables"),
    ;

    private static Map<String, ResourceClass> resourceByName;
    private final String name;

    ResourceClass(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static Optional<ResourceClass> byName(String name) {
        if (ResourceClass.resourceByName == null) {
            Map<String, ResourceClass> tmp = new HashMap<>();
            Stream.of(ResourceClass.values())
                    .forEach(v -> tmp.put(v.name, v));
            ResourceClass.resourceByName = ImmutableMap.copyOf(tmp);
        }

        return Optional.ofNullable(ResourceClass.resourceByName.get(name));
    }
}
