package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pricing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.collect.ImmutableMap;

/**
 * SKU providers enum.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public enum SKUProvider {
    AVATARS("Avatars"),
    DISTBUILD("DistBuild"),
    GENCFG("GenCfg"),
    HARDWARE("Hardware"),
    MDS_MEDIA_STORAGE("MDS (media storage)"),
    MANAGED_SERVICE_FOR_APACHE_KAFKA("Managed Service for Apache Kafka®"),
    MANAGED_SERVICE_FOR_CLICKHOUSE("Managed Service for Clickhouse"),
    MANAGED_SERVICE_FOR_ELASTICSEARCH("Managed Service for Elasticsearch"),
    MANAGED_SERVICE_FOR_MONGODB("Managed Service for MongoDB"),
    MANAGED_SERVICE_FOR_MYSQL("Managed Service for MySQL®"),
    MANAGED_SERVICE_FOR_POSTGRESQL("Managed Service for PostgreSQL"),
    MANAGED_SERVICE_FOR_REDIS("Managed Service for Redis™"),
    OFFLINE_MDB_CLUSTERS("Offline MDB clusters"),
    QLOUD("QLoud"),
    S3("S3"),
    STRM("STRM"),
    SAAS("SaaS (Search as a service)"),
    SANDBOX("Sandbox"),
    YP("YP"),
    YT("YT"),
    YANDEX_DATA_PROC("Yandex Data Proc"),
    YANDEX_NETWORK("Yandex network (NOC)"),
    YDB("Yandex Database")
    ;

    private static Map<String, SKUProvider> providerByName;

    private final String name;

    SKUProvider(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static Optional<SKUProvider> byName(String name) {
        if (SKUProvider.providerByName == null) {
            Map<String, SKUProvider> tmp = new HashMap<>();
            Stream.of(SKUProvider.values())
                    .forEach(v -> tmp.put(v.name, v));
            SKUProvider.providerByName = ImmutableMap.copyOf(tmp);
        }

        return Optional.ofNullable(SKUProvider.providerByName.get(name));
    }
}
