package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pricing;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.collect.ImmutableList;

/**
 * Tmp class for parsing raw text of SKU.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class SKURawText {
    private final static String[] raw =
            {
                    "01.01.2021;Avatars;avatars.api.delete.hdd.lrc;Avatars. Метод DELETE. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.hdd.x2;Avatars. Метод DELETE. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.hdd.x3;Avatars. Метод DELETE. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.hdd.x4;Avatars. Метод DELETE. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.hdd.x5;Avatars. Метод DELETE. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.ssd.lrc;Avatars. Метод DELETE. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.ssd.x2;Avatars. Метод DELETE. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.ssd.x3;Avatars. Метод DELETE. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.ssd.x4;Avatars. Метод DELETE. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.delete.ssd.x5;Avatars. Метод DELETE. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.get.hdd.lrc;Avatars. Метод GET. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.hdd.x2;Avatars. Метод GET. Класс хранения hdd.x2;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.hdd.x3;Avatars. Метод GET. Класс хранения hdd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.hdd.x4;Avatars. Метод GET. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.hdd.x5;Avatars. Метод GET. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.ssd.lrc;Avatars. Метод GET. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.ssd.x2;Avatars. Метод GET. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.ssd.x3;Avatars. Метод GET. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.ssd.x4;Avatars. Метод GET. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.get.ssd.x5;Avatars. Метод GET. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.hdd.lrc;Avatars. Метод HEAD. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.hdd.x2;Avatars. Метод HEAD. Класс хранения hdd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.hdd.x3;Avatars. Метод HEAD. Класс хранения hdd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.hdd.x4;Avatars. Метод HEAD. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.hdd.x5;Avatars. Метод HEAD. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.ssd.lrc;Avatars. Метод HEAD. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.ssd.x2;Avatars. Метод HEAD. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.ssd.x3;Avatars. Метод HEAD. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.ssd.x4;Avatars. Метод HEAD. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.head.ssd.x5;Avatars. Метод HEAD. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2022;Avatars;avatars.api.network.crossdc.RU-CENTRAL;Avatars. Сеть. Класс трафика crossdc.RU-CENTRAL;Network;0.029181599;gbyte",
                    "01.01.2022;Avatars;avatars.api.network.crossdc.RU-CENTRAL_FIN;Avatars. Сеть. Класс трафика crossdc.RU-CENTRAL_FIN;Network;0.029181599;gbyte",
                    "01.01.2022;Avatars;avatars.api.network.external-dc-geo.egress;Avatars. Сеть. Класс трафика external-dc-geo.egress;Network;0.199023438;gbyte",
                    "01.01.2022;Avatars;avatars.api.network.external-dc-geo.ingress;Avatars. Сеть. Класс трафика external-dc-geo.ingress;Network;0.199023438;gbyte",
                    "01.01.2021;Avatars;avatars.api.options.hdd.lrc;Avatars. Метод OPTIONS. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.hdd.x2;Avatars. Метод OPTIONS. Класс хранения hdd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.hdd.x3;Avatars. Метод OPTIONS. Класс хранения hdd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.hdd.x4;Avatars. Метод OPTIONS. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.hdd.x5;Avatars. Метод OPTIONS. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.ssd.lrc;Avatars. Метод OPTIONS. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.ssd.x2;Avatars. Метод OPTIONS. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.ssd.x3;Avatars. Метод OPTIONS. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.ssd.x4;Avatars. Метод OPTIONS. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.options.ssd.x5;Avatars. Метод OPTIONS. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;Avatars;avatars.api.post.hdd.lrc;Avatars. Метод POST. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.hdd.x2;Avatars. Метод POST. Класс хранения hdd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.hdd.x3;Avatars. Метод POST. Класс хранения hdd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.hdd.x4;Avatars. Метод POST. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.hdd.x5;Avatars. Метод POST. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.ssd.lrc;Avatars. Метод POST. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.ssd.x2;Avatars. Метод POST. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.ssd.x3;Avatars. Метод POST. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.ssd.x4;Avatars. Метод POST. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.post.ssd.x5;Avatars. Метод POST. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.hdd.lrc;Avatars. Метод PUT. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.hdd.x2;Avatars. Метод PUT. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.hdd.x3;Avatars. Метод PUT. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.hdd.x4;Avatars. Метод PUT. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.hdd.x5;Avatars. Метод PUT. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.ssd.lrc;Avatars. Метод PUT. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.ssd.x2;Avatars. Метод PUT. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.ssd.x3;Avatars. Метод PUT. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.ssd.x4;Avatars. Метод PUT. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.api.put.ssd.x5;Avatars. Метод PUT. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;Avatars;avatars.quota_space.hdd.lrc;Avatars. Квота. Класс хранения hdd.lrc;UNKNOWN;0.000232639;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.hdd.x2;Avatars. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.hdd.x3;Avatars. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.hdd.x4;Avatars. Квота. Класс хранения hdd.x4;HDD;0.000595694;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.hdd.x5;Avatars. Квота. Класс хранения hdd.x5;HDD;0.000727222;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.ssd.lrc;Avatars. Квота. Класс хранения ssd.lrc;UNKNOWN;0.003164444;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.ssd.x2;Avatars. Квота. Класс хранения ssd.x2;UNKNOWN;0.003955556;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.ssd.x3;Avatars. Квота. Класс хранения ssd.x3;UNKNOWN;0.005933333;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.ssd.x4;Avatars. Квота. Класс хранения ssd.x4;UNKNOWN;0.007911111;gbyte*hour",
                    "01.01.2021;Avatars;avatars.quota_space.ssd.x5;Avatars. Квота. Класс хранения ssd.x5;UNKNOWN;0.009888889;gbyte*hour",
                    "01.01.2022;DistBuild;distbuild.compute.guarantee.slots_autocheck_segment;Гарантия на вычислительные ресурсы в сегменте автосборки;CPU;532.22;compute_unit*month",
                    "01.01.2022;DistBuild;distbuild.compute.guarantee.slots_user_segment;Гарантия на вычислительные ресурсы в сегменте пользовательских сборок\";CPU;462.8;compute_unit*month",
                    "01.01.2021;GenCfg;gencfg.cpu.quota;Квота на ядра. Сервис GenCfg;CPU;162.81;core*month",
                    "01.01.2021;GenCfg;gencfg.hdd_storage.quota;Квота на HDD хранилище. Сервис GenCfg;HDD;0.115;gbyte*month",
                    "01.01.2021;GenCfg;gencfg.memory.quota;Квота на память. Сервис GenCfg;RAM;25.12;gbyte*month",
                    "01.01.2021;GenCfg;gencfg.ssd_storage.quota;Квота на SSD хранилище. Сервис GenCfg;SSD;1.566;gbyte*month",
                    "01.01.2022;Hardware;hardware.cpu;Ядра;UNKNOWN;162.81;core*month",
                    "01.01.2022;Hardware;hardware.hdd_storage;Дисковое пространство на на HDD;UNKNOWN;0.1115;gbyte*month",
                    "01.01.2022;Hardware;hardware.memory;Оперативная память;UNKNOWN;25.12;gbyte*month",
                    "01.01.2022;Hardware;hardware.ssd_storage;Дисковое пространство на SSD;UNKNOWN;1.5666;gbyte*month",
                    "01.01.2021;MDS (media storage);mds.api.delete.hdd.lrc;Mds. Метод DELETE. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.hdd.x2;Mds. Метод DELETE. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.hdd.x3;Mds. Метод DELETE. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.hdd.x4;Mds. Метод DELETE. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.hdd.x5;Mds. Метод DELETE. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.ssd.lrc;Mds. Метод DELETE. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.ssd.x2;Mds. Метод DELETE. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.ssd.x3;Mds. Метод DELETE. Класс хранения ssd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.ssd.x4;Mds. Метод DELETE. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.delete.ssd.x5;Mds. Метод DELETE. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.hdd.lrc;Mds. Метод GET. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.hdd.x2;Mds. Метод GET. Класс хранения hdd.x2;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.hdd.x3;Mds. Метод GET. Класс хранения hdd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.hdd.x4;Mds. Метод GET. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.hdd.x5;Mds. Метод GET. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.ssd.lrc;Mds. Метод GET. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.ssd.x2;Mds. Метод GET. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.ssd.x3;Mds. Метод GET. Класс хранения ssd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.ssd.x4;Mds. Метод GET. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.get.ssd.x5;Mds. Метод GET. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.hdd.lrc;Mds. Метод HEAD. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.hdd.x2;Mds. Метод HEAD. Класс хранения hdd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.hdd.x3;Mds. Метод HEAD. Класс хранения hdd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.hdd.x4;Mds. Метод HEAD. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.hdd.x5;Mds. Метод HEAD. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.ssd.lrc;Mds. Метод HEAD. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.ssd.x2;Mds. Метод HEAD. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.ssd.x3;Mds. Метод HEAD. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.ssd.x4;Mds. Метод HEAD. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.head.ssd.x5;Mds. Метод HEAD. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2022;MDS (media storage);mds.api.network.crossdc.RU-CENTRAL;Mds. Сеть. Класс трафика crossdc.RU-CENTRAL;Network;0.029181599;gbyte",
                    "01.01.2022;MDS (media storage);mds.api.network.crossdc.RU-CENTRAL_FIN;Mds. Сеть. Класс трафика crossdc.RU-CENTRAL_FIN;Network;0.029181599;gbyte",
                    "01.01.2022;MDS (media storage);mds.api.network.external-dc-geo.egress;Mds. Сеть. Класс трафика external-dc-geo.egress;Network;0.199023438;gbyte",
                    "01.01.2022;MDS (media storage);mds.api.network.external-dc-geo.ingress;Mds. Сеть. Класс трафика external-dc-geo.ingress;Network;0.199023438;gbyte",
                    "01.01.2021;MDS (media storage);mds.api.options.hdd.lrc;Mds. Метод OPTIONS. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.hdd.x2;Mds. Метод OPTIONS. Класс хранения hdd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.hdd.x3;Mds. Метод OPTIONS. Класс хранения hdd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.hdd.x4;Mds. Метод OPTIONS. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.hdd.x5;Mds. Метод OPTIONS. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.ssd.lrc;Mds. Метод OPTIONS. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.ssd.x2;Mds. Метод OPTIONS. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.ssd.x3;Mds. Метод OPTIONS. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.ssd.x4;Mds. Метод OPTIONS. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.options.ssd.x5;Mds. Метод OPTIONS. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.hdd.lrc;Mds. Метод POST. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.hdd.x2;Mds. Метод POST. Класс хранения hdd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.hdd.x3;Mds. Метод POST. Класс хранения hdd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.hdd.x4;Mds. Метод POST. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.hdd.x5;Mds. Метод POST. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.ssd.lrc;Mds. Метод POST. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.ssd.x2;Mds. Метод POST. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.ssd.x3;Mds. Метод POST. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.ssd.x4;Mds. Метод POST. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.post.ssd.x5;Mds. Метод POST. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.hdd.lrc;Mds. Метод PUT. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.hdd.x2;Mds. Метод PUT. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.hdd.x3;Mds. Метод PUT. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.hdd.x4;Mds. Метод PUT. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.hdd.x5;Mds. Метод PUT. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.ssd.lrc;Mds. Метод PUT. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.ssd.x2;Mds. Метод PUT. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.ssd.x3;Mds. Метод PUT. Класс хранения ssd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.ssd.x4;Mds. Метод PUT. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.api.put.ssd.x5;Mds. Метод PUT. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;MDS (media storage);mds.quota_space.hdd.lrc;Mds. Квота. Класс хранения hdd.lrc;HDD;0.000232639;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.hdd.x2;Mds. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.hdd.x3;Mds. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.hdd.x4;Mds. Квота. Класс хранения hdd.x4;HDD;0.000595694;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.hdd.x5;Mds. Квота. Класс хранения hdd.x5;UNKNOWN;0.000727222;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.ssd.lrc;Mds. Квота. Класс хранения ssd.lrc;UNKNOWN;0.003164444;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.ssd.x2;Mds. Квота. Класс хранения ssd.x2;SSD;0.003955556;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.ssd.x3;Mds. Квота. Класс хранения ssd.x3;SSD;0.005933333;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.ssd.x4;Mds. Квота. Класс хранения ssd.x4;UNKNOWN;0.007911111;gbyte*hour",
                    "01.01.2021;MDS (media storage);mds.quota_space.ssd.x5;Mds. Квота. Класс хранения ssd.x5;UNKNOWN;0.009888889;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.public_ip;Публичный IP-адрес - Apache Kafka®;UNKNOWN;0.1524;fip*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v1.cpu.c100;Apache Kafka®. Intel Sandy Bridge. 100% vCPU;UNKNOWN;0.2435;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v1.cpu.c50;Apache Kafka®. Intel Sandy Bridge. 50% vCPU;UNKNOWN;0.1218;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v1.ram;Apache Kafka®. Intel Sandy Bridge. RAM;UNKNOWN;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v2.cpu.c100;Apache Kafka®. Intel Broadwell. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v2.cpu.c50;Apache Kafka®. Intel Broadwell. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v2.ram;Apache Kafka®. Intel Broadwell. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v3.cpu.c100;Apache Kafka®. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v3.ram;Apache Kafka®. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.local-hdd.kafka;Локальное хранилище (HDD) — Apache Kafka®;UNKNOWN;0.0002;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.local-nvme.kafka;Быстрое локальное хранилище — Apache Kafka®;NVMe;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.local-ssd.kafka;Быстрое локальное хранилище (SSD) — Apache Kafka®;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.network-hdd.kafka;Стандартное сетевое хранилище — Apache Kafka®;UNKNOWN;0.00317792;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.network-nvme.kafka;Быстрое сетевое хранилище — Apache Kafka®;UNKNOWN;0.01129944;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v1.cpu.c100;ZooKeeper для Apache Kafka®. Intel Sandy Bridge. 100% vCPU;UNKNOWN;0.2319;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v1.cpu.c50;ZooKeeper для Apache Kafka®. Intel Sandy Bridge. 50% vCPU;UNKNOWN;0.116;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v1.ram;ZooKeeper для Apache Kafka®. Intel Sandy Bridge. RAM;UNKNOWN;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v2.cpu.c100;ZooKeeper для Apache Kafka®. Intel Broadwell. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v2.cpu.c20;ZooKeeper для Apache Kafka®. Intel Broadwell. 20% vCPU;UNKNOWN;0.35;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v2.cpu.c5;ZooKeeper для Apache Kafka®. Intel Broadwell. 5% vCPU;UNKNOWN;0.15;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v2.cpu.c50;ZooKeeper для Apache Kafka®. Intel Broadwell. 50% vCPU;UNKNOWN;0.49;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v2.ram;ZooKeeper для Apache Kafka®. Intel Broadwell. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v3.cpu.c100;ZooKeeper для Apache Kafka®. Intel Cascade Lake. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for Apache Kafka®;mdb.zk.kafka.v3.ram;ZooKeeper для Apache Kafka®. Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.clickhouse.adjustment.kop;Корректировка для MDB ClickHouse;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v1.cpu.c100;ClickHouse. Intel Sandy Bridge. 100% vCPU;CPU;0.2482;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v1.cpu.c20;ClickHouse. Intel Sandy Bridge. 20% vCPU;UNKNOWN;0.26;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v1.cpu.c5;ClickHouse. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.02;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v1.cpu.c50;ClickHouse. Intel Sandy Bridge. 50% vCPU;CPU;0.1241;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v1.ram;ClickHouse. Intel Sandy Bridge. RAM;RAM;0.0373;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v2.cpu.c100;ClickHouse. Intel Broadwell. 100% vCPU;CPU;0.2482;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v2.cpu.c20;ClickHouse. Intel Broadwell. 20% vCPU;UNKNOWN;0.26;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v2.cpu.c5;ClickHouse. Intel Broadwell. 5% vCPU;UNKNOWN;0.02;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v2.cpu.c50;ClickHouse. Intel Broadwell. 50% vCPU;UNKNOWN;0.43;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v2.ram;ClickHouse. Intel Broadwell. RAM;RAM;0.0373;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.cpu.c100;ClickHouse. Intel Cascade Lake. 100% vCPU;CPU;0.2482;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.cpu.c20;ClickHouse. Intel Cascade Lake. 20% vCPU;UNKNOWN;0.26;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.cpu.c5;ClickHouse. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.02;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.cpu.c50;ClickHouse. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.43;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.ram;ClickHouse. Intel Cascade Lake. RAM;RAM;0.0373;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.local-hdd.ch;Стандартное локальное хранилище — ClickHouse;HDD;0.0002;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.local-nvme.ch;Быстрое локальное хранилище — ClickHouse;UNKNOWN;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.local-ssd.ch;Быстрое локальное хранилище (SSD) — ClickHouse;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.network-hdd.ch;Стандартное сетевое хранилище — ClickHouse;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.cluster.network-nvme.ch;Быстрое сетевое хранилище — ClickHouse;UNKNOWN;0.008;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.software_accelerated_network.clickhouse.v1.cores;ClickHouse. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.software_accelerated_network.clickhouse.v2.cores;ClickHouse. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.software_accelerated_network.clickhouse.v3.cores;ClickHouse. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.cpu.c100;ZooKeeper. Intel Sandy Bridge. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.cpu.c20;ZooKeeper. Intel Sandy Bridge. 20% vCPU;UNKNOWN;0.35;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.cpu.c5;ZooKeeper. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.15;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.cpu.c50;ZooKeeper. Intel Sandy Bridge. 50% vCPU;CPU;0.116;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.ram;ZooKeeper. Intel Sandy Bridge. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v1.software_accelerated_network.cpu;ZooKeeper. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.cpu.c100;ZooKeeper. Intel Broadwell. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.cpu.c20;ZooKeeper. Intel Broadwell. 20% vCPU;UNKNOWN;0.35;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.cpu.c5;ZooKeeper. Intel Broadwell. 5% vCPU;UNKNOWN;0.15;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.cpu.c50;ZooKeeper. Intel Broadwell. 50% vCPU;UNKNOWN;0.49;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.ram;ZooKeeper. Intel Broadwell. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v2.software_accelerated_network.cpu;ZooKeeper. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.cpu.c100;ZooKeeper. Intel Cascade Lake. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.cpu.c20;ZooKeeper. Intel Cascade Lake. 20% vCPU;UNKNOWN;0.35;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.cpu.c5;ZooKeeper. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.15;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.cpu.c50;ZooKeeper. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.49;core*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.ram;ZooKeeper. Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for Clickhouse;mdb.zk.clickhouse.v3.software_accelerated_network.cpu;ZooKeeper. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v1.cpu.c100;Elasticsearch. Intel Broadwell. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v1.cpu.c50;Elasticsearch. Intel Broadwell. 50% vCPU;UNKNOWN;0.1276;core*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v1.ram;Elasticsearch. Intel Broadwell. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v2.cpu.c100;Elasticsearch. Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v2.ram;Elasticsearch. Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v3.cpu.c100;Elasticsearch. Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v3.ram;Elasticsearch. Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.local-nvme.elasticsearch;Быстрое локальное хранилище — Elasticsearch;NVMe;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Elasticsearch;mdb.cluster.local-ssd.elasticsearch;Быстрое локальное хранилище (SSD)— Elasticsearch;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.local-hdd.mongodb;Стандартное локальное хранилище — MongoDB;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.local-nvme.mongodb;Быстрое локальное хранилище (NVME) — MongoDB;UNKNOWN;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.local-ssd.mongodb;Быстрое локальное хранилище (SSD) — MongoDB;SSD;0.001295;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v1.cpu.c100;MongoDB (mongocfg). Intel Broadwell. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v1.cpu.c20;MongoDB (mongocfg). Intel Broadwell. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v1.cpu.c5;MongoDB (mongocfg). Intel Broadwell. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v1.cpu.c50;MongoDB (mongocfg). Intel Broadwell. 50% vCPU;CPU;0.1276;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v1.ram;MongoDB (mongocfg). Intel Broadwell. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v2.cpu.c100;MongoDB (mongocfg). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v2.cpu.c20;MongoDB (mongocfg). Intel Cascade Lake. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v2.cpu.c5;MongoDB (mongocfg). Intel Cascade Lake. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v2.cpu.c50;MongoDB (mongocfg). Intel Cascade Lake. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v2.ram;MongoDB (mongocfg). Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v3.cpu.c100;MongoDB (mongocfg). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongocfg.v3.ram;MongoDB (mongocfg). Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v1.cpu.c100;MongoDB (mongoinfra). Intel Broadwell. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v1.cpu.c20;MongoDB (mongoinfra). Intel Broadwell. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v1.cpu.c5;MongoDB (mongoinfra). Intel Broadwell. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v1.cpu.c50;MongoDB (mongoinfra). Intel Broadwell. 50% vCPU;UNKNOWN;0.1276;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v1.ram;MongoDB (mongoinfra). Intel Broadwell. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v2.cpu.c100;MongoDB (mongoinfra). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v2.cpu.c20;MongoDB (mongoinfra). Intel Cascade Lake. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v2.cpu.c5;MongoDB (mongoinfra). Intel Cascade Lake. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v2.cpu.c50;MongoDB (mongoinfra). Intel Cascade Lake. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v2.ram;MongoDB (mongoinfra). Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v3.cpu.c100;MongoDB (mongoinfra). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongoinfra.v3.ram;MongoDB (mongoinfra). Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v1.cpu.c100;MongoDB (mongos). Intel Broadwell. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v1.cpu.c20;MongoDB (mongos). Intel Broadwell. 20% vCPU;UNKNOWN;0.078415595;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v1.cpu.c5;MongoDB (mongos). Intel Broadwell. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v1.cpu.c50;MongoDB (mongos). Intel Broadwell. 50% vCPU;CPU;0.1276;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v1.ram;MongoDB (mongos). Intel Broadwell. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v2.cpu.c100;MongoDB (mongos). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v2.cpu.c20;MongoDB (mongos). Intel Cascade Lake. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v2.cpu.c5;MongoDB (mongos). Intel Cascade Lake. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v2.cpu.c50;MongoDB (mongos). Intel Cascade Lake. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v2.ram;MongoDB (mongos). Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v3.cpu.c100;MongoDB (mongos). Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.mongos.v3.ram;MongoDB (mongos). Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v1.cpu.c100;MongoDB. Intel Sandy Bridge. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v1.cpu.c20;MongoDB. Intel Sandy Bridge. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v1.cpu.c5;MongoDB. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v1.cpu.c50;MongoDB. Intel Sandy Bridge. 50% vCPU;CPU;0.1276;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v1.ram;MongoDB. Intel Sandy Bridge. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v2.cpu.c100;MongoDB. Intel Broadwell. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v2.cpu.c20;MongoDB. Intel Broadwell. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v2.cpu.c5;MongoDB. Intel Broadwell. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v2.cpu.c50;MongoDB. Intel Broadwell. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v2.ram;MongoDB. Intel Broadwell. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.cpu.c100;MongoDB. Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.cpu.c20;MongoDB. Intel Cascade Lake. 20% vCPU;UNKNOWN;0.29;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.cpu.c5;MongoDB. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.cpu.c50;MongoDB. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.ram;MongoDB. Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.network-hdd.mongodb;Стандартное сетевое хранилище — MongoDB;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.cluster.network-nvme.mongodb;Быстрое сетевое хранилище — MongoDB;UNKNOWN;0.008;gbyte*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.mongo.adjustment.kop;Корректировка для MDB MongoDB;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongocfg.v1.cores;MongoDB (mongocfg). Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongocfg.v2.cores;MongoDB (mongocfg). Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongoinfra.v1.cores;MongoDB (mongoinfra). Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongoinfra.v2.cores;MongoDB (mongoinfra). Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongos.v1.cores;MongoDB (mongos). Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.mongos.v2.cores;MongoDB (mongos). Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.v1.cores;MongoDB. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.v2.cores;MongoDB. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MongoDB;mdb.software_accelerated_network.mongodb.v3.cores;MongoDB. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.local-hdd.mysql;Стандартное локальное хранилище — MySQL;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.local-nvme.mysql;Быстрое локальное хранилище — MySQL;NVMe;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.local-ssd.mysql;Быстрое локальное хранилище (SSD) — MySQL;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v1.cpu.c100;MySQL. Intel Sandy Bridge. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v1.cpu.c20;MySQL. Intel Sandy Bridge. 20% vCPU;UNKNOWN;0.27;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v1.cpu.c5;MySQL. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v1.cpu.c50;MySQL. Intel Sandy Bridge. 50% vCPU;CPU;0.1218;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v1.ram;MySQL. Intel Sandy Bridge. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v2.cpu.c100;MySQL. Intel Broadwell. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v2.cpu.c20;MySQL. Intel Broadwell. 20% vCPU;UNKNOWN;0.27;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v2.cpu.c5;MySQL. Intel Broadwell. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v2.cpu.c50;MySQL. Intel Broadwell. 50% vCPU;UNKNOWN;0.45;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v2.ram;MySQL. Intel Broadwell. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.cpu.c100;MySQL. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.cpu.c20;MySQL. Intel Cascade Lake. 20% vCPU;UNKNOWN;0.27;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.cpu.c5;MySQL. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.03;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.cpu.c50;MySQL. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.45;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.ram;MySQL. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.network-hdd.mysql;Стандартное сетевое хранилище — MySQL;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.cluster.network-nvme.mysql;Быстрое сетевое хранилище — MySQL;UNKNOWN;0.008;gbyte*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.mysql.adjustment.kop;Корректировка для MDB MySQL;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for MySQL®;mdb.software_accelerated_network.mysql.v1.cores;MySQL. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.software_accelerated_network.mysql.v2.cores;MySQL. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for MySQL®;mdb.software_accelerated_network.mysql.v3.cores;MySQL. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.local-hdd.pg;Стандартное локальное хранилище — PostgreSQL;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.local-nvme.pg;Быстрое локальное хранилище (NVME) — PostgreSQL;UNKNOWN;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.local-ssd.pg;Быстрое локальное хранилище — PostgreSQL;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.network-hdd.pg;Стандартное сетевое хранилище — PostgreSQL;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.network-nvme.pg;Быстрое сетевое хранилище — PostgreSQL;UNKNOWN;0.008;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v1.cpu.c100;PostgreSQL. Intel Sandy Bridge. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v1.cpu.c20;PostgreSQL. Intel Sandy Bridge. 20% vCPU;UNKNOWN;0.28;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v1.cpu.c5;PostgreSQL. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.04;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v1.cpu.c50;PostgreSQL. Intel Sandy Bridge. 50% vCPU;CPU;0.116;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v1.ram;PostgreSQL. Intel Sandy Bridge. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v2.cpu.c100;PostgreSQL. Intel Broadwell. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v2.cpu.c20;PostgreSQL. Intel Broadwell. 20% vCPU;UNKNOWN;0.28;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v2.cpu.c5;PostgreSQL. Intel Broadwell. 5% vCPU;UNKNOWN;0.04;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v2.cpu.c50;PostgreSQL. Intel Broadwell. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v2.ram;PostgreSQL. Intel Broadwell. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.cpu.c100;PostgreSQL. Intel Cascade Lake. 100% vCPU;CPU;0.2319;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.cpu.c20;PostgreSQL. Intel Cascade Lake. 20% vCPU;UNKNOWN;0.28;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.cpu.c5;PostgreSQL. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.04;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.cpu.c50;PostgreSQL. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.47;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.ram;PostgreSQL. Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.pg.adjustment.kop;Корректировка для MDB PostgreSQL;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.software_accelerated_network.pg.v1.cores;PostgreSQL. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.software_accelerated_network.pg.v2.cores;PostgreSQL. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for PostgreSQL;mdb.software_accelerated_network.pg.v3.cores;PostgreSQL. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.local-hdd.redis;Стандартное локальное хранилище — Redis;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.local-nvme.redis;Быстрое локальное хранилище (NVME) — Redis;UNKNOWN;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.local-ssd.redis;Быстрое локальное хранилище (SSD) — Redis;SSD;0.0023;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.network-hdd.redis;Стандартное сетевое хранилище — Redis;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.network-nvme.redis;Быстрое сетевое хранилище — Redis;UNKNOWN;0.008;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v1.cpu.c100;Redis. Intel Sandy Bridge. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v1.cpu.c20;Redis. Intel Broadwell. 20% vCPU;UNKNOWN;0.23;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v1.cpu.c5;Redis. Intel Sandy Bridge. 5% vCPU;UNKNOWN;0.07;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v1.cpu.c50;Redis. Intel Sandy Bridge. 50% vCPU;UNKNOWN;0.1218;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v1.ram;Redis. Intel Sandy Bridge. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v2.cpu.c100;Redis. Intel Broadwell. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v2.cpu.c5;Redis. Intel Broadwell. 5% vCPU;UNKNOWN;0.07;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v2.cpu.c50;Redis. Intel Broadwell. 50% vCPU;UNKNOWN;0.63;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v2.ram;Redis. Intel Broadwell. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.cpu.c100;Redis. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.cpu.c5;Redis. Intel Cascade Lake. 5% vCPU;UNKNOWN;0.07;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.cpu.c50;Redis. Intel Cascade Lake. 50% vCPU;UNKNOWN;0.63;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.ram;Redis. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.offline.adjustment.kop;Корректировка для MDB Offline;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for Redis™;mdb.redis.adjustment.kop;Корректировка для MDB Redis;UNKNOWN;1;rub",
                    "01.01.2021;Managed Service for Redis™;mdb.software_accelerated_network.redis.v1.cores;Redis. Intel Sandy Bridge. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.software_accelerated_network.redis.v2.cores;Redis. Intel Broadwell. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Managed Service for Redis™;mdb.software_accelerated_network.redis.v3.cores;Redis. Intel Cascade Lake. Программно ускоренная сеть;UNKNOWN;1.34;core*hour",
                    "01.01.2021;Offline MDB clusters;mdb.cluster.local-hdd.offline;Стандартное локальное хранилище (HDD) — Offline;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Offline MDB clusters;mdb.cluster.local-ssd.offline;Стандартное локальное хранилище (SSD) — Offline;UNKNOWN;0.0022;gbyte*hour",
                    "01.01.2021;Offline MDB clusters;mdb.cpu.offline;Offline. 100% vCPU;UNKNOWN;0.116;core*hour",
                    "01.01.2021;Offline MDB clusters;mdb.local-nvme.offline;Быстрое локальное хранилище (NVME) — Offline;UNKNOWN;0.0023;gbyte*hour",
                    "01.01.2021;Offline MDB clusters;mdb.ram.offline;Offline. RAM;UNKNOWN;0.0174;gbyte*hour",
                    "01.01.2021;QLoud;qloud.cpu.quota;Квота на ядра. Сервис Qloud;CPU;162.81;core*month",
                    "01.01.2021;QLoud;qloud.memory.quota;Квота на память. Сервис Qloud;RAM;25.12;gbyte*month",
                    "01.01.2021;S3;s3.api.delete.hdd.lrc;S3. Метод DELETE. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.hdd.x2;S3. Метод DELETE. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.hdd.x3;S3. Метод DELETE. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.hdd.x4;S3. Метод DELETE. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.hdd.x5;S3. Метод DELETE. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.ssd.lrc;S3. Метод DELETE. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.ssd.x2;S3. Метод DELETE. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.ssd.x3;S3. Метод DELETE. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.ssd.x4;S3. Метод DELETE. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.delete.ssd.x5;S3. Метод DELETE. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.get.hdd.lrc;S3. Метод GET. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.hdd.x2;S3. Метод GET. Класс хранения hdd.x2;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.hdd.x3;S3. Метод GET. Класс хранения hdd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.hdd.x4;S3. Метод GET. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.hdd.x5;S3. Метод GET. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.ssd.lrc;S3. Метод GET. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.ssd.x2;S3. Метод GET. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.ssd.x3;S3. Метод GET. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.ssd.x4;S3. Метод GET. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.get.ssd.x5;S3. Метод GET. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.hdd.lrc;S3. Метод HEAD. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.hdd.x2;S3. Метод HEAD. Класс хранения hdd.x2;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.hdd.x3;S3. Метод HEAD. Класс хранения hdd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.hdd.x4;S3. Метод HEAD. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.hdd.x5;S3. Метод HEAD. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.ssd.lrc;S3. Метод HEAD. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.ssd.x2;S3. Метод HEAD. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.ssd.x3;S3. Метод HEAD. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.ssd.x4;S3. Метод HEAD. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.head.ssd.x5;S3. Метод HEAD. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2022;S3;s3.api.network.crossdc.RU-CENTRAL;S3. Сеть. Класс трафика crossdc.RU-CENTRAL;Network;0.029181599;gbyte",
                    "01.01.2022;S3;s3.api.network.crossdc.RU-CENTRAL_FIN;S3. Сеть. Класс трафика crossdc.RU-CENTRAL_FIN;Network;0.029181599;gbyte",
                    "01.01.2022;S3;s3.api.network.external-dc-geo.egress;S3. Сеть. Класс трафика external-dc-geo.egress;Network;0.199023438;gbyte",
                    "01.01.2022;S3;s3.api.network.external-dc-geo.ingress;S3. Сеть. Класс трафика external-dc-geo.ingress;Network;0.199023438;gbyte",
                    "01.01.2021;S3;s3.api.options.hdd.lrc;S3. Метод OPTIONS. Класс хранения hdd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.hdd.x2;S3. Метод OPTIONS. Класс хранения hdd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.hdd.x3;S3. Метод OPTIONS. Класс хранения hdd.x3;Storage.Querys;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.hdd.x4;S3. Метод OPTIONS. Класс хранения hdd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.hdd.x5;S3. Метод OPTIONS. Класс хранения hdd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.ssd.lrc;S3. Метод OPTIONS. Класс хранения ssd.lrc;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.ssd.x2;S3. Метод OPTIONS. Класс хранения ssd.x2;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.ssd.x3;S3. Метод OPTIONS. Класс хранения ssd.x3;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.ssd.x4;S3. Метод OPTIONS. Класс хранения ssd.x4;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.options.ssd.x5;S3. Метод OPTIONS. Класс хранения ssd.x5;UNKNOWN;0.0452;10k*request",
                    "01.01.2021;S3;s3.api.post.hdd.lrc;S3. Метод POST. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.hdd.x2;S3. Метод POST. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.hdd.x3;S3. Метод POST. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.hdd.x4;S3. Метод POST. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.hdd.x5;S3. Метод POST. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.ssd.lrc;S3. Метод POST. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.ssd.x2;S3. Метод POST. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.ssd.x3;S3. Метод POST. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.ssd.x4;S3. Метод POST. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.post.ssd.x5;S3. Метод POST. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.hdd.lrc;S3. Метод PUT. Класс хранения hdd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.hdd.x2;S3. Метод PUT. Класс хранения hdd.x2;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.hdd.x3;S3. Метод PUT. Класс хранения hdd.x3;Storage.Querys;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.hdd.x4;S3. Метод PUT. Класс хранения hdd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.hdd.x5;S3. Метод PUT. Класс хранения hdd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.ssd.lrc;S3. Метод PUT. Класс хранения ssd.lrc;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.ssd.x2;S3. Метод PUT. Класс хранения ssd.x2;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.ssd.x3;S3. Метод PUT. Класс хранения ssd.x3;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.ssd.x4;S3. Метод PUT. Класс хранения ssd.x4;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.api.put.ssd.x5;S3. Метод PUT. Класс хранения ssd.x5;UNKNOWN;0.0452;1k*request",
                    "01.01.2021;S3;s3.quota_space.hdd.lrc;S3. Квота. Класс хранения hdd.lrc;HDD;0.000232639;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.hdd.x2;S3. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.hdd.x3;S3. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.hdd.x4;S3. Квота. Класс хранения hdd.x4;HDD;0.000595694;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.hdd.x5;S3. Квота. Класс хранения hdd.x5;HDD;0.000727222;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.ssd.lrc;S3. Квота. Класс хранения ssd.lrc;UNKNOWN;0.003164444;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.ssd.x2;S3. Квота. Класс хранения ssd.x2;SSD;0.003955556;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.ssd.x3;S3. Квота. Класс хранения ssd.x3;SSD;0.005933333;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.ssd.x4;S3. Квота. Класс хранения ssd.x4;UNKNOWN;0.007911111;gbyte*hour",
                    "01.01.2021;S3;s3.quota_space.ssd.x5;S3. Квота. Класс хранения ssd.x5;UNKNOWN;0.009888889;gbyte*hour",
                    "01.01.2022;STRM;strm.cdn.traffic.egress;STRM исходящий трафик;Network;107;tbyte",
                    "01.01.2022;SaaS (Search as a service);saas.cpu.allocated;Аллоцированные ядра. Сервис SaaS;CPU;187.2;core*month",
                    "01.01.2022;SaaS (Search as a service);saas.hdd_storage.allocated;Аллоцированное дисковое пространство на HDD. Сервис SaaS;HDD;0.132;gbyte*month",
                    "01.01.2022;SaaS (Search as a service);saas.memory.allocated;Аллоцированная память. Сервис SaaS;RAM;28.88;gbyte*month",
                    "01.01.2022;SaaS (Search as a service);saas.ssd_storage.allocated;Аллоцированное дисковое пространство на SSD. Сервис SaaS;SSD;1.8;gbyte*month",
                    "01.01.2022;Sandbox;sandbox.compute.guarantee.slots_hdd_segment;Гарантия на вычислительные ресурсы в сегменте HDD;CPU;245.36;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.guarantee.slots_macos_segment;Гарантия на вычислительные ресурсы в сегменте MACOS;CPU;283.16;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.guarantee.slots_ssd_segment;Гарантия на вычислительные ресурсы в сегменте SSD;CPU;283.16;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.guarantee.slots_windows_segment;Гарантия на вычислительные ресурсы в сегменте WINDOWS;CPU;283.16;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.usage.slots_hdd_segment;Потребление вычислительных ресурсов в сегменте HDD;CPU;105.16;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.usage.slots_macos_segment;Потребление вычислительных ресурсов в сегменте MACOS;CPU;121.35;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.usage.slots_ssd_segment;Потребление вычислительных ресурсов в сегменте SSD;CPU;121.35;core*month",
                    "01.01.2022;Sandbox;sandbox.compute.usage.slots_windows_segment;Потребление вычислительных ресурсов в сегменте WINDOWS;CPU;121.35;core*month",
                    "01.01.2022;Sandbox;sandbox.storage.api.delete;Количество запросов DELETE в API хранилища ресурсов;UNKNOWN;0.0452;1k*request",
                    "01.01.2022;Sandbox;sandbox.storage.api.get;Количество запросов GET в API хранилища ресурсов;UNKNOWN;0.0452;10k*request",
                    "01.01.2022;Sandbox;sandbox.storage.api.put;Количество запросов PUT в API хранилища ресурсов;UNKNOWN;0.0452;1k*request",
                    "01.01.2022;Sandbox;sandbox.storage.quota_space;Квота на место в хранилище ресурсов;Storage;0.2094;gbyte*month",
                    "01.01.2021;YP;yp.cpu.quota;Квота на ядра. Сервис YP;CPU;162.81;core*month",
                    "01.01.2022;YP;yp.gpu_geforce_1080ti.quota;Квота на GPU GeForce 1080ti. Сервис YP;GPU;12148;gpu*month",
                    "01.01.2022;YP;yp.gpu_tesla_k40.quota;Квота на GPU Tesla K40. Сервис YP;GPU;3883;gpu*month",
                    "01.01.2022;YP;yp.gpu_tesla_m40.quota;Квота на GPU Tesla M40. Сервис YP;GPU;4656;gpu*month",
                    "01.01.2022;YP;yp.gpu_tesla_v100.quota;Квота на GPU Tesla V100. Сервис YP;GPU;35121;gpu*month",
                    "01.01.2021;YP;yp.hdd_storage.quota;Квота на HDD хранилище. Сервис YP;HDD;0.115;gbyte*month",
                    "01.01.2021;YP;yp.memory.quota;Квота на память. Сервис YP;RAM;25.12;gbyte*month",
                    "01.01.2021;YP;yp.ssd_storage.quota;Квота на SSD хранилище. Сервис YP;SSD;1.566;gbyte*month",
                    "01.01.2021;YT;yt.arnold.compute.integral_guarantee.burst.cpu;Arnold. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.arnold.compute.integral_guarantee.relaxed.cpu;Arnold. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.arnold.compute.strong_guarantee.cpu;Arnold. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.arnold.compute.usage.cpu;Arnold. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.arnold.compute.usage.memory;Arnold. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.arnold.disk_space.hdd;Arnold. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.arnold.disk_space.ssd;Arnold. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.arnold.dynamic_tables.tablet_cell;Arnold. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.geforce_1080ti.strong_guarantee.gpu;Arnold. Geforce_1080Ti Строгая гарантия на карту;GPU;8503.6;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.geforce_1080ti.usage.gpu;Arnold. Использование карты Geforce_1080Ti;GPU;3644.4;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_a100.strong_guarantee.gpu;Arnold. Tesla_A100 Строгая гарантия на карту;UNKNOWN;33087.6;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_a100.usage.gpu;Arnold. Использование карты Tesla_A100;UNKNOWN;14180.4;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_a100_80g.strong_guarantee.gpu;Arnold. Tesla_A100_80G Строгая гарантия на карту;UNKNOWN;37807;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_a100_80g.usage.gpu;Arnold. Использование карты Tesla_A100_80G;UNKNOWN;16203;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_k40.strong_guarantee.gpu;Arnold. Tesla_K40 Строгая гарантия на карту;UNKNOWN;2718.1;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_k40.usage.gpu;Arnold. Использование карты Tesla_K40;UNKNOWN;1164.9;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_m40.strong_guarantee.gpu;Arnold. Tesla_M40 Строгая гарантия на карту;UNKNOWN;3259.2;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_m40.usage.gpu;Arnold. Использование карты Tesla_M40;UNKNOWN;1396.8;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_p40.strong_guarantee.gpu;Arnold. Tesla_P40 Строгая гарантия на карту;UNKNOWN;3261.3;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_p40.usage.gpu;Arnold. Использование карты Tesla_P40;UNKNOWN;1397.7;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_v100.strong_guarantee.gpu;Arnold. Tesla_v100 Строгая гарантия на карту;GPU;24584.7;compute_unit*month",
                    "01.01.2022;YT;yt.arnold.gpu.tesla_v100.usage.gpu;Arnold. Использование карты Tesla_v100;GPU;10536.3;compute_unit*month",
                    "01.01.2021;YT;yt.bohr.compute.integral_guarantee.burst.cpu;Bohr. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.bohr.compute.integral_guarantee.relaxed.cpu;Bohr. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.bohr.compute.strong_guarantee.cpu;Bohr. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.bohr.compute.usage.cpu;Bohr. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.bohr.compute.usage.memory;Bohr. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.bohr.disk_space.hdd;Bohr. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.bohr.disk_space.ssd;Bohr. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.bohr.dynamic_tables.tablet_cell;Bohr. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.freud.compute.integral_guarantee.burst.cpu;Freud. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.freud.compute.integral_guarantee.relaxed.cpu;Freud. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.freud.compute.strong_guarantee.cpu;Freud. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.freud.compute.usage.cpu;Freud. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.freud.compute.usage.memory;Freud. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.freud.disk_space.hdd;Freud. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.freud.disk_space.ssd;Freud. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.freud.dynamic_tables.tablet_cell;Freud. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.hahn.compute.integral_guarantee.burst.cpu;Hahn. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.hahn.compute.integral_guarantee.relaxed.cpu;Hahn. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.hahn.compute.strong_guarantee.cpu;Hahn. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.hahn.compute.usage.cpu;Hahn. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.hahn.compute.usage.memory;Hahn. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.hahn.disk_space.hdd;Hahn. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.hahn.disk_space.ssd;Hahn. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.hahn.dynamic_tables.tablet_cell;Hahn. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.geforce_1080ti.strong_guarantee.gpu;Hahn. Geforce_1080Ti Строгая гарантия на карту;GPU;8503.6;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.geforce_1080ti.usage.gpu;Hahn. Использование карты Geforce_1080Ti;GPU;3644.4;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_a100.strong_guarantee.gpu;Hahn. Tesla_A100 Строгая гарантия на карту;GPU;33087.6;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_a100.usage.gpu;Hahn. Использование карты Tesla_A100;GPU;14180.4;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_a100_80g.strong_guarantee.gpu;Hahn. Tesla_A100_80G Строгая гарантия на карту;GPU;37807;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_a100_80g.usage.gpu;Hahn. Использование карты Tesla_A100_80G;GPU;16203;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_k40.strong_guarantee.gpu;Hahn. Tesla_K40 Строгая гарантия на карту;GPU;2718.1;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_k40.usage.gpu;Hahn. Использование карты Tesla_K40;GPU;1164.9;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_m40.strong_guarantee.gpu;Hahn. Tesla_M40 Строгая гарантия на карту;GPU;3259.2;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_m40.usage.gpu;Hahn. Использование карты Tesla_M40;GPU;1396.8;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_p40.strong_guarantee.gpu;Hahn. Tesla_P40 Строгая гарантия на карту;GPU;3261.3;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_p40.usage.gpu;Hahn. Использование карты Tesla_P40;GPU;1397.7;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_v100.strong_guarantee.gpu;Hahn. Tesla_v100 Строгая гарантия на карту;GPU;24584.7;compute_unit*month",
                    "01.01.2022;YT;yt.hahn.gpu.tesla_v100.usage.gpu;Hahn. Использование карты Tesla_v100;GPU;10536.3;compute_unit*month",
                    "01.01.2021;YT;yt.hume.compute.integral_guarantee.burst.cpu;Hume. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.hume.compute.integral_guarantee.relaxed.cpu;Hume. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.hume.compute.strong_guarantee.cpu;Hume. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.hume.compute.usage.cpu;Hume. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.hume.compute.usage.memory;Hume. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.hume.disk_space.hdd;Hume. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.hume.disk_space.ssd;Hume. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.hume.dynamic_tables.tablet_cell;Hume. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.landau.compute.integral_guarantee.burst.cpu;Landau. Пиковая гарантия;CPU;24.872;compute_unit*month",
                    "01.01.2021;YT;yt.landau.compute.integral_guarantee.relaxed.cpu;Landau. Интегральная гарантия;CPU;99.489;compute_unit*month",
                    "01.01.2021;YT;yt.landau.compute.strong_guarantee.cpu;Landau. Строгая гарантия;CPU;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.landau.compute.usage.cpu;Landau. CPU;CPU;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.landau.compute.usage.memory;Landau. Оперативная память;RAM;29.693;gbyte*month",
                    "01.01.2021;YT;yt.landau.disk_space.hdd;Landau. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.landau.disk_space.ssd;Landau. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.landau.dynamic_tables.tablet_cell;Landau. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.markov.disk_space.hdd;Markov. Аллоцированное место на hdd;UNKNOWN;0.115;gbyte*month",
                    "01.01.2021;YT;yt.markov.disk_space.ssd;Markov. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.markov.dynamic_tables.tablet_cell;Markov. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month",
                    "01.01.2021;YT;yt.pythia.compute.strong_guarantee.cpu;Pythia. Строгая гарантия;UNKNOWN;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.pythia.compute.usage.cpu;Pythia. CPU;UNKNOWN;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.pythia.compute.usage.memory;Pythia. Оперативная память;UNKNOWN;29.693;gbyte*month",
                    "01.01.2021;YT;yt.pythia.disk_space.hdd;Pythia. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.pythia.disk_space.ssd;Pythia. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.pythia.dynamic_tables.tablet_cell;Pythia. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.seneca-man.disk_space.hdd;Seneca-Man. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.seneca-man.disk_space.ssd;Seneca-Man. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.seneca-man.dynamic_tables.tablet_cell;Seneca-Man. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month",
                    "01.01.2021;YT;yt.seneca-sas.disk_space.hdd;Seneca-Sas. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.seneca-sas.disk_space.ssd;Seneca-Sas. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.seneca-sas.dynamic_tables.tablet_cell;Seneca-Sas. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month",
                    "01.01.2021;YT;yt.seneca-vla.disk_space.hdd;Seneca-Vla. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.seneca-vla.disk_space.ssd;Seneca-Vla. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.seneca-vla.dynamic_tables.tablet_cell;Seneca-Vla. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month",
                    "01.01.2021;YT;yt.vanga.compute.strong_guarantee.cpu;Vanga. Строгая гарантия;UNKNOWN;124.361;compute_unit*month",
                    "01.01.2021;YT;yt.vanga.compute.usage.cpu;Vanga. CPU;UNKNOWN;53.297;compute_unit*month",
                    "01.01.2021;YT;yt.vanga.compute.usage.memory;Vanga. Оперативная память;UNKNOWN;29.693;gbyte*month",
                    "01.01.2021;YT;yt.vanga.disk_space.hdd;Vanga. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.vanga.disk_space.ssd;Vanga. Аллоцированное место на ssd;UNKNOWN;1.566;gbyte*month",
                    "01.01.2022;YT;yt.vanga.dynamic_tables.tablet_cell;Vanga. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month",
                    "01.01.2021;YT;yt.zeno.disk_space.hdd;Zeno. Аллоцированное место на hdd;HDD;0.115;gbyte*month",
                    "01.01.2021;YT;yt.zeno.disk_space.ssd;Zeno. Аллоцированное место на ssd;SSD;1.566;gbyte*month",
                    "01.01.2022;YT;yt.zeno.dynamic_tables.tablet_cell;Zeno. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.adjustment.kop;Корректировка для MDB Data Proc;UNKNOWN;1;rub",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.gpu.cpu.c100;Yandex Data Proc - Intel Broadwell with Nvidia Tesla v100. 100% vCPU;UNKNOWN;0.071;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.gpu.gpu;Yandex Data Proc - Intel Broadwell with Nvidia Tesla v100. GPU;UNKNOWN;15.596;gpu*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.gpu.ram;Yandex Data Proc - Intel Broadwell with Nvidia Tesla v100. RAM;UNKNOWN;0.02;gbyte*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v1.cpu.c100;Yandex Data Proc - Intel Broadwell. 100% vCPU;UNKNOWN;0.071;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v1.cpu.c20;Yandex Data Proc - Intel Broadwell. 20% vCPU;UNKNOWN;0.0142;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v1.ram;Yandex Data Proc - Intel Broadwell. RAM;UNKNOWN;0.02;gbyte*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v2.cpu.c100;Yandex Data Proc - Intel Cascade Lake. 100% vCPU;UNKNOWN;0.075;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v2.cpu.c20;Yandex Data Proc - Intel Cascade Lake. 20% vCPU;UNKNOWN;0.015;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v2.cpu.c50;Yandex Data Proc - Intel Cascade Lake. 50% vCPU;UNKNOWN;0.0375;core*hour",
                    "01.01.2021;Yandex Data Proc;mdb.dataproc.v2.ram;Yandex Data Proc - Intel Cascade Lake. RAM;UNKNOWN;0.02;gbyte*hour",
                    "01.01.2022;Yandex network (NOC);net.bandwidth.dci.bb.FIN;Сеть между ДЦ РФ <-> Финляндия (полоса backbone);Network;16369;gbit/second",
                    "01.01.2022;Yandex network (NOC);net.bandwidth.dci.bb.RU-CENTRAL;Сеть между ДЦ по РФ (полоса backbone);Network;9411;gbit/second",
                    "01.01.2021;Yandex network (NOC);net.dc.port.standard;Порт на серверном свиче (стандартный);UNKNOWN;1049;instance",
                    "01.01.2022;Yandex network (NOC);net.traffic.dci.fb.FIN;Трафик fastbone между ДЦ в РФ и MAN;Network;53;tbyte",
                    "01.01.2022;Yandex network (NOC);net.traffic.dci.fb.RU-CENTRAL;Трафик fastbone между ДЦ по РФ;Network;16;tbyte",
                    "01.01.2022;Yandex network (NOC);net.traffic.ext;Внешний трафик (не-CDN);Network;204;tbyte"
            };
    private static final List<PricingModel> pricingModels = ImmutableList.copyOf(Arrays.stream(raw)
            .map(str -> toPricingModel(str.split(";")))
            .collect(Collectors.toList()));

    static {
        if (pricingModels.stream().map(PricingModel::getSKU).distinct().count() != pricingModels.size()) {
            throw new IllegalStateException("All SKU keys must be unique!");
        }
    }

    private static PricingModel toPricingModel(String[] arr) {
        return PricingModel.builder()
                .date(arr[0])
                .provider(SKUProvider.byName(arr[1]).orElseThrow())
                .SKU(arr[2])
                .SKUDescription(arr[3])
                .resourceClass(ResourceClass.byName(arr[4]).orElseThrow())
                .price(arr[5])
                .pricingUnit(arr[6])
                .build();
    }

    public static Stream<PricingModel> toPricingModelStream() {
        return pricingModels.stream();
    }

    private SKURawText() {
    }
}
