package ru.yandex.qe.dispenser.ws.quota.request.owning_cost.pricing

import java.util.stream.Stream

class SkuRawText2022 {

    companion object {
        private val raw: String = """
            01.01.2021;Avatars;avatars.quota_space.hdd.lrc;Avatars. Квота. Класс хранения hdd.lrc;UNKNOWN;0.000232639;gbyte*hour
            01.01.2021;Avatars;avatars.quota_space.hdd.x2;Avatars. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour
            01.01.2021;Avatars;avatars.quota_space.hdd.x3;Avatars. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour
            01.01.2021;Avatars;avatars.quota_space.ssd.x2;Avatars. Квота. Класс хранения ssd.x2;UNKNOWN;0.003955556;gbyte*hour
            01.01.2021;Avatars;avatars.quota_space.ssd.x3;Avatars. Квота. Класс хранения ssd.x3;UNKNOWN;0.005933333;gbyte*hour
            01.01.2021;MDS (media storage);mds.quota_space.hdd.lrc;Mds. Квота. Класс хранения hdd.lrc;HDD;0.000232639;gbyte*hour
            01.01.2021;MDS (media storage);mds.quota_space.hdd.x2;Mds. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour
            01.01.2021;MDS (media storage);mds.quota_space.hdd.x3;Mds. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour
            01.01.2021;MDS (media storage);mds.quota_space.ssd.x2;Mds. Квота. Класс хранения ssd.x2;SSD;0.003955556;gbyte*hour
            01.01.2021;MDS (media storage);mds.quota_space.ssd.x3;Mds. Квота. Класс хранения ssd.x3;SSD;0.005933333;gbyte*hour
            01.01.2021;S3;s3.quota_space.hdd.x2;S3. Квота. Класс хранения hdd.x2;HDD;0.000290833;gbyte*hour
            01.01.2021;S3;s3.quota_space.hdd.x3;S3. Квота. Класс хранения hdd.x3;HDD;0.00043625;gbyte*hour
            01.01.2022;DistBuild;distbuild.compute.guarantee.slots_autocheck_segment;Гарантия на вычислительные ресурсы в сегменте автосборки;CPU;532.22;compute_unit*month
            01.01.2022;DistBuild;distbuild.compute.guarantee.slots_user_segment;Гарантия на вычислительные ресурсы в сегменте пользовательских сборок";CPU;462.8;compute_unit*month
            01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v3.cpu.c100;Apache Kafka®. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour
            01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.kafka.v3.ram;Apache Kafka®. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour
            01.01.2021;Managed Service for Apache Kafka®;mdb.cluster.local-ssd.kafka;Быстрое локальное хранилище (SSD) — Apache Kafka®;SSD;0.0023;gbyte*hour
            01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.cpu.c100;ClickHouse. Intel Cascade Lake. 100% vCPU;CPU;0.2482;core*hour
            01.01.2021;Managed Service for Clickhouse;mdb.cluster.clickhouse.v3.ram;ClickHouse. Intel Cascade Lake. RAM;RAM;0.0373;gbyte*hour
            01.01.2021;Managed Service for Clickhouse;mdb.cluster.local-hdd.ch;Стандартное локальное хранилище — ClickHouse;HDD;0.0002;gbyte*hour
            01.01.2021;Managed Service for Clickhouse;mdb.cluster.local-ssd.ch;Быстрое локальное хранилище (SSD) — ClickHouse;SSD;0.0023;gbyte*hour
            01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v3.cpu.c100;Elasticsearch. Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour
            01.01.2021;Managed Service for Elasticsearch;mdb.cluster.elasticsearch.v3.ram;Elasticsearch. Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour
            01.01.2021;Managed Service for Elasticsearch;mdb.cluster.local-ssd.elasticsearch;Быстрое локальное хранилище (SSD)— Elasticsearch;SSD;0.0023;gbyte*hour
            01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.cpu.c100;MongoDB. Intel Cascade Lake. 100% vCPU;CPU;0.2551;core*hour
            01.01.2021;Managed Service for MongoDB;mdb.cluster.mongodb.v3.ram;MongoDB. Intel Cascade Lake. RAM;RAM;0.0384;gbyte*hour
            01.01.2021;Managed Service for MongoDB;mdb.cluster.local-ssd.mongodb;Быстрое локальное хранилище (SSD) — MongoDB;SSD;0.001295;gbyte*hour
            01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.cpu.c100;MySQL. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour
            01.01.2021;Managed Service for MySQL®;mdb.cluster.mysql.v3.ram;MySQL. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour
            01.01.2021;Managed Service for MySQL®;mdb.cluster.local-ssd.mysql;Быстрое локальное хранилище (SSD) — MySQL;SSD;0.0023;gbyte*hour
            01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.cpu.c100;PostgreSQL. Intel Cascade Lake. 100% vCPU;CPU;0.2319;core*hour
            01.01.2021;Managed Service for PostgreSQL;mdb.cluster.pg.v3.ram;PostgreSQL. Intel Cascade Lake. RAM;RAM;0.0349;gbyte*hour
            01.01.2021;Managed Service for PostgreSQL;mdb.cluster.local-ssd.pg;Быстрое локальное хранилище — PostgreSQL;SSD;0.0023;gbyte*hour
            01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.cpu.c100;Redis. Intel Cascade Lake. 100% vCPU;CPU;0.2435;core*hour
            01.01.2021;Managed Service for Redis™;mdb.cluster.redis.v3.ram;Redis. Intel Cascade Lake. RAM;RAM;0.0366;gbyte*hour
            01.01.2021;Managed Service for Redis™;mdb.cluster.local-ssd.redis;Быстрое локальное хранилище (SSD) — Redis;SSD;0.0023;gbyte*hour
            01.01.2022;SaaS (Search as a service);saas.cpu.allocated;Аллоцированные ядра. Сервис SaaS;CPU;187.2;core*month
            01.01.2022;SaaS (Search as a service);saas.hdd_storage.allocated;Аллоцированное дисковое пространство на HDD. Сервис SaaS;HDD;0.132;gbyte*month
            01.01.2022;SaaS (Search as a service);saas.memory.allocated;Аллоцированная память. Сервис SaaS;RAM;28.88;gbyte*month
            01.01.2022;SaaS (Search as a service);saas.ssd_storage.allocated;Аллоцированное дисковое пространство на SSD. Сервис SaaS;SSD;1.8;gbyte*month
            01.01.2022;Sandbox;sandbox.compute.guarantee.slots_hdd_segment;Гарантия на вычислительные ресурсы в сегменте HDD;CPU;245.36;core*month
            01.01.2022;Sandbox;sandbox.compute.guarantee.slots_macos_segment;Гарантия на вычислительные ресурсы в сегменте MACOS;CPU;283.16;core*month
            01.01.2022;Sandbox;sandbox.compute.guarantee.slots_ssd_segment;Гарантия на вычислительные ресурсы в сегменте SSD;CPU;283.16;core*month
            01.01.2022;Sandbox;sandbox.compute.guarantee.slots_windows_segment;Гарантия на вычислительные ресурсы в сегменте WINDOWS;CPU;283.16;core*month
            01.01.2022;Sandbox;sandbox.compute.usage.slots_hdd_segment;Потребление вычислительных ресурсов в сегменте HDD;CPU;105.16;core*month
            01.01.2022;Sandbox;sandbox.compute.usage.slots_macos_segment;Потребление вычислительных ресурсов в сегменте MACOS;CPU;121.35;core*month
            01.01.2022;Sandbox;sandbox.compute.usage.slots_ssd_segment;Потребление вычислительных ресурсов в сегменте SSD;CPU;121.35;core*month
            01.01.2022;Sandbox;sandbox.compute.usage.slots_windows_segment;Потребление вычислительных ресурсов в сегменте WINDOWS;CPU;121.35;core*month
            01.01.2022;STRM;strm.cdn.traffic.egress;STRM исходящий трафик;Network;107;tbyte
            01.01.2021;YP;yp.cpu.quota;Квота на ядра. Сервис YP;CPU;162.81;core*month
            01.01.2022;YP;yp.gpu_tesla_v100.quota;Квота на GPU Tesla V100. Сервис YP;GPU;35121;gpu*month
            01.01.2021;YP;yp.hdd_storage.quota;Квота на HDD хранилище. Сервис YP;HDD;0.115;gbyte*month
            01.01.2021;YP;yp.memory.quota;Квота на память. Сервис YP;RAM;25.12;gbyte*month
            01.01.2021;YP;yp.ssd_storage.quota;Квота на SSD хранилище. Сервис YP;SSD;1.566;gbyte*month
            01.01.2021;YT;yt.arnold.compute.integral_guarantee.burst.cpu;Arnold. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.arnold.compute.integral_guarantee.relaxed.cpu;Arnold. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.arnold.compute.strong_guarantee.cpu;Arnold. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.arnold.compute.usage.cpu;Arnold. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.arnold.compute.usage.memory;Arnold. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.arnold.disk_space.hdd;Arnold. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.arnold.disk_space.ssd;Arnold. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.arnold.dynamic_tables.tablet_cell;Arnold. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2022;YT;yt.arnold.gpu.tesla_a100_80g.strong_guarantee.gpu;Arnold. Tesla_A100_80G Строгая гарантия на карту;UNKNOWN;37807;compute_unit*month
            01.01.2022;YT;yt.arnold.gpu.tesla_a100_80g.usage.gpu;Arnold. Использование карты Tesla_A100_80G;UNKNOWN;16203;compute_unit*month
            01.01.2021;YT;yt.bohr.compute.integral_guarantee.burst.cpu;Bohr. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.bohr.compute.integral_guarantee.relaxed.cpu;Bohr. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.bohr.compute.strong_guarantee.cpu;Bohr. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.bohr.compute.usage.cpu;Bohr. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.bohr.compute.usage.memory;Bohr. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.bohr.disk_space.hdd;Bohr. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.bohr.disk_space.ssd;Bohr. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.bohr.dynamic_tables.tablet_cell;Bohr. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.freud.compute.integral_guarantee.burst.cpu;Freud. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.freud.compute.integral_guarantee.relaxed.cpu;Freud. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.freud.compute.strong_guarantee.cpu;Freud. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.freud.compute.usage.cpu;Freud. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.freud.compute.usage.memory;Freud. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.freud.disk_space.hdd;Freud. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.freud.disk_space.ssd;Freud. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.freud.dynamic_tables.tablet_cell;Freud. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.hahn.compute.integral_guarantee.burst.cpu;Hahn. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.hahn.compute.integral_guarantee.relaxed.cpu;Hahn. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.hahn.compute.strong_guarantee.cpu;Hahn. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.hahn.compute.usage.cpu;Hahn. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.hahn.compute.usage.memory;Hahn. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.hahn.disk_space.hdd;Hahn. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.hahn.disk_space.ssd;Hahn. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.hahn.dynamic_tables.tablet_cell;Hahn. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2022;YT;yt.hahn.gpu.tesla_a100_80g.strong_guarantee.gpu;Hahn. Tesla_A100_80G Строгая гарантия на карту;GPU;37807;compute_unit*month
            01.01.2022;YT;yt.hahn.gpu.tesla_a100_80g.usage.gpu;Hahn. Использование карты Tesla_A100_80G;GPU;16203;compute_unit*month
            01.01.2021;YT;yt.hume.compute.integral_guarantee.burst.cpu;Hume. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.hume.compute.integral_guarantee.relaxed.cpu;Hume. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.hume.compute.strong_guarantee.cpu;Hume. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.hume.compute.usage.cpu;Hume. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.hume.compute.usage.memory;Hume. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.hume.disk_space.hdd;Hume. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.hume.disk_space.ssd;Hume. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.hume.dynamic_tables.tablet_cell;Hume. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.landau.compute.integral_guarantee.burst.cpu;Landau. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.landau.compute.integral_guarantee.relaxed.cpu;Landau. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.landau.compute.strong_guarantee.cpu;Landau. Строгая гарантия;CPU;124.361;compute_unit*month
            01.01.2021;YT;yt.landau.compute.usage.cpu;Landau. CPU;CPU;53.297;compute_unit*month
            01.01.2021;YT;yt.landau.compute.usage.memory;Landau. Оперативная память;RAM;29.693;gbyte*month
            01.01.2021;YT;yt.landau.disk_space.hdd;Landau. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.landau.disk_space.ssd;Landau. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.landau.dynamic_tables.tablet_cell;Landau. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.markov.compute.integral_guarantee.burst.cpu;Markov. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.markov.compute.integral_guarantee.relaxed.cpu;Markov. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.markov.compute.usage.cpu;Markov. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.markov.compute.usage.memory;Markov. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.markov.disk_space.hdd;Markov. Аллоцированное место на hdd;UNKNOWN;0.115;gbyte*month
            01.01.2021;YT;yt.markov.disk_space.ssd;Markov. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.markov.dynamic_tables.tablet_cell;Markov. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month
            01.01.2021;YT;yt.pythia.compute.strong_guarantee.cpu;Pythia. Строгая гарантия;UNKNOWN;124.361;compute_unit*month
            01.01.2021;YT;yt.pythia.compute.integral_guarantee.burst.cpu;Pythia. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.pythia.compute.integral_guarantee.relaxed.cpu;Pythia. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.pythia.compute.usage.cpu;Pythia. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.pythia.compute.usage.memory;Pythia. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.pythia.disk_space.hdd;Pythia. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.pythia.disk_space.ssd;Pythia. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.pythia.dynamic_tables.tablet_cell;Pythia. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.seneca-man.disk_space.hdd;Seneca-Man. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.seneca-man.disk_space.ssd;Seneca-Man. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.seneca-man.dynamic_tables.tablet_cell;Seneca-Man. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month
            01.01.2021;YT;yt.seneca-sas.compute.usage.cpu;Seneca-Sas. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.seneca-sas.compute.usage.memory;Seneca-Sas. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.seneca-sas.compute.integral_guarantee.burst.cpu;Seneca-Sas. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.seneca-sas.compute.integral_guarantee.relaxed.cpu;Seneca-Sas. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.seneca-sas.disk_space.hdd;Seneca-Sas. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.seneca-sas.disk_space.ssd;Seneca-Sas. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.seneca-sas.dynamic_tables.tablet_cell;Seneca-Sas. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month
            01.01.2021;YT;yt.seneca-vla.compute.usage.cpu;Seneca-Vla. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.seneca-vla.compute.usage.memory;Seneca-Vla. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.seneca-vla.compute.integral_guarantee.burst.cpu;Seneca-Vla. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.seneca-vla.compute.integral_guarantee.relaxed.cpu;Seneca-Vla. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.seneca-vla.disk_space.hdd;Seneca-Vla. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.seneca-vla.disk_space.ssd;Seneca-Vla. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.seneca-vla.dynamic_tables.tablet_cell;Seneca-Vla. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month
            01.01.2021;YT;yt.seneca-klg.disk_space.hdd;Seneca-Klg. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.seneca-klg.disk_space.ssd;Seneca-Klg. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2021;YT;yt.seneca-klg.compute.usage.cpu;Seneca-Klg. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.seneca-klg.compute.usage.memory;Seneca-Klg. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.seneca-klg.compute.integral_guarantee.burst.cpu;Seneca-Klg. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.seneca-klg.compute.integral_guarantee.relaxed.cpu;Seneca-Klg. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.nash.disk_space.hdd;Nash. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.nash.disk_space.ssd;Nash. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2021;YT;yt.nash.compute.usage.cpu;Nash. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.nash.compute.usage.memory;Nash. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.nash.compute.integral_guarantee.burst.cpu;Nash. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.nash.compute.integral_guarantee.relaxed.cpu;Nash. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.vanga.compute.strong_guarantee.cpu;Vanga. Строгая гарантия;UNKNOWN;124.361;compute_unit*month
            01.01.2021;YT;yt.vanga.compute.integral_guarantee.burst.cpu;Vanga. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.vanga.compute.integral_guarantee.relaxed.cpu;Vanga. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.vanga.compute.usage.cpu;Vanga. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.vanga.compute.usage.memory;Vanga. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.vanga.disk_space.hdd;Vanga. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.vanga.disk_space.ssd;Vanga. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.vanga.dynamic_tables.tablet_cell;Vanga. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;679.313;dyntable_unit*month
            01.01.2021;YT;yt.zeno.compute.integral_guarantee.burst.cpu;Zeno. Пиковая гарантия;CPU;24.872;compute_unit*month
            01.01.2021;YT;yt.zeno.compute.integral_guarantee.relaxed.cpu;Zeno. Интегральная гарантия;CPU;99.489;compute_unit*month
            01.01.2021;YT;yt.zeno.compute.usage.cpu;Zeno. CPU;UNKNOWN;53.297;compute_unit*month
            01.01.2021;YT;yt.zeno.compute.usage.memory;Zeno. Оперативная память;UNKNOWN;29.693;gbyte*month
            01.01.2021;YT;yt.zeno.disk_space.hdd;Zeno. Аллоцированное место на hdd;HDD;0.115;gbyte*month
            01.01.2021;YT;yt.zeno.disk_space.ssd;Zeno. Аллоцированное место на ssd;SSD;1.566;gbyte*month
            01.01.2022;YT;yt.zeno.dynamic_tables.tablet_cell;Zeno. Выделенные мощности для Динамических таблиц;YT.Dynamic_Tables;1711.85;dyntable_unit*month
            01.01.2022;Yandex Database;ydb.ssd_storage.quota;Квота на SSD хранилище. Сервис Yandex Database;SSD;9.396;gbyte*month
            01.01.2022;Yandex Database;ydb.cpu.quota;Квота на ядра. Сервис Yandex Database;CPU;177.658;core*month
            01.01.2022;Yandex Database;ydb.memory.quota;Квота на память. Сервис Yandex Database;RAM;29.693;gbyte*month
        """.trimIndent()

        private val pricingModels: List<PricingModel> = raw.lines().map { toPricingModel(it.split(';')) }

        init {
            if (pricingModels.map { it.sku }.distinct().size != pricingModels.size) {
                throw IllegalStateException("All SKU keys must be unique!")
            }
        }

        private fun toPricingModel(fields: List<String>): PricingModel {
            return PricingModel.builder()
                .date(fields[0])
                .provider(SKUProvider.byName(fields[1]).orElseThrow())
                .SKU(fields[2])
                .SKUDescription(fields[3])
                .resourceClass(ResourceClass.byName(fields[4]).orElseThrow())
                .price(fields[5])
                .pricingUnit(fields[6])
                .build()
        }

        @JvmStatic
        fun toPricingModelStream(): Stream<PricingModel> {
            return pricingModels.stream()
        }

    }

}
