package ru.yandex.qe.dispenser.ws.quota.request.unbalanced;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * Quota request unbalance refresh manager.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class QuotaChangeUnbalanceRefreshManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaChangeUnbalanceRefreshManager.class);
    private static final int MAX_REPEATS = 10000;

    private final QuotaChangeUnbalanceRefreshTransactionWrapper quotaChangeUnbalanceRefreshTransactionWrapper;

    public QuotaChangeUnbalanceRefreshManager(QuotaChangeUnbalanceRefreshTransactionWrapper quotaChangeUnbalanceRefreshTransactionWrapper) {
        this.quotaChangeUnbalanceRefreshTransactionWrapper = quotaChangeUnbalanceRefreshTransactionWrapper;
    }

    /**
     * Recalculate unbalance for request from valid campaigns.
     */
    public void refresh() {
        int i = 0;
        Long fromId = null;
        while ((fromId = quotaChangeUnbalanceRefreshTransactionWrapper.execute(fromId)) != null) {
            if (++i > MAX_REPEATS) {
                LOG.warn("Infinity loop detected!");
                break;
            }
        }
    }
}
