package ru.yandex.qe.dispenser.ws.quota.request.unbalanced;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * Segment key for quota request unbalance calculation dry-run.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class SegmentKey {
    @NotNull
    private final String segmentKey;
    @NotNull
    private final String segmentationKey;

    private SegmentKey(@NotNull String segmentKey, @NotNull String segmentationKey) {
        this.segmentKey = segmentKey;
        this.segmentationKey = segmentationKey;
    }

    @NotNull
    public String getSegmentKey() {
        return segmentKey;
    }

    @NotNull
    public String getSegmentationKey() {
        return segmentationKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentKey that = (SegmentKey) o;
        return Objects.equals(segmentKey, that.segmentKey) && Objects.equals(segmentationKey, that.segmentationKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentKey, segmentationKey);
    }

    @Override
    public String toString() {
        return "SegmentKey{" +
                "segmentKey='" + segmentKey + '\'' +
                ", segmentationKey='" + segmentationKey + '\'' +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String segmentKey;
        private String segmentationKey;

        public Builder segmentKey(String segmentKey) {
            this.segmentKey = segmentKey;
            return this;
        }

        public Builder segmentationKey(String segmentationKey) {
            this.segmentationKey = segmentationKey;
            return this;
        }

        public SegmentKey build() {
            return new SegmentKey(
                    Objects.requireNonNull(segmentKey),
                    Objects.requireNonNull(segmentationKey)
            );
        }
    }
}
