package ru.yandex.qe.dispenser.ws.quota.request.workflow;

import javax.inject.Inject;

import org.springframework.stereotype.Component;
import ru.yandex.qe.dispenser.domain.GoalQuestionHelper;
import ru.yandex.qe.dispenser.domain.dao.bot.settings.BotCampaignGroupDao;
import ru.yandex.qe.dispenser.domain.dao.campaign.CampaignDao;
import ru.yandex.qe.dispenser.domain.dao.goal.GoalDao;
import ru.yandex.qe.dispenser.ws.quota.request.QuotaChangeRequestManager;
import ru.yandex.qe.dispenser.ws.quota.request.owning_cost.QuotaChangeOwningCostManager;
import ru.yandex.qe.dispenser.ws.quota.request.ticket.QuotaChangeRequestTicketManager;
import ru.yandex.qe.dispenser.ws.quota.request.unbalanced.QuotaChangeUnbalancedManager;
import ru.yandex.qe.dispenser.ws.quota.request.workflow.service.ServiceDictionaryRestrictionManager;

/**
 * Bean creator for quota workflow's
 */
@SuppressWarnings("OverlyCoupledClass")
@Component
public class QuotaRequestWorkflowManager {

    private final ResourceWorkflow resourceWorkflow;

    @SuppressWarnings({"ConstructorWithTooManyParameters", "OverlyCoupledMethod"})
    @Inject
    protected QuotaRequestWorkflowManager(final QuotaChangeRequestTicketManager quotaChangeRequestTicketManager,
                                          final CampaignDao campaignDao,
                                          final QuotaChangeRequestManager requestManager,
                                          final ServiceDictionaryRestrictionManager serviceDictionaryRestrictionManager,
                                          final GoalDao goalDao,
                                          final GoalQuestionHelper goalQuestionHelper,
                                          final BotCampaignGroupDao campaignGroupDao,
                                          final QuotaChangeOwningCostManager quotaChangeOwningCostManager,
                                          final QuotaChangeUnbalancedManager quotaChangeUnbalancedManager,
                                          final AuthorizationManager authorizationManager) {
        resourceWorkflow = new ResourceWorkflow(quotaChangeRequestTicketManager,
                campaignDao, requestManager, serviceDictionaryRestrictionManager, goalDao, goalQuestionHelper,
                campaignGroupDao, quotaChangeOwningCostManager, quotaChangeUnbalancedManager, authorizationManager);
    }

    public ResourceWorkflow getResourceWorkflow() {
        return resourceWorkflow;
    }

}
