package ru.yandex.qe.dispenser.ws.quota.request.workflow.context;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.request.quota.Body;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.dao.goal.Goal;

@ParametersAreNonnullByDefault
public class CreateRequestContext extends RequestContext {
    @NotNull
    private final List<QuotaChangeRequest.Change> changes;
    @NotNull
    private final Body body;

    public CreateRequestContext(final Person person, final Project project,
                                final List<QuotaChangeRequest.Change> changes,
                                final Body body,
                                @Nullable final Goal goal,
                                @NotNull final QuotaChangeRequest.Campaign campaign,
                                @Nullable final BotCampaignGroup campaignGroup) {
        super(person, project, changes.stream().map(c -> c.getResource().getService()).collect(Collectors.toSet()), goal, campaign, campaignGroup);
        this.changes = changes;
        this.body = body;
    }

    @NotNull
    public List<QuotaChangeRequest.Change> getChanges() {
        return changes;
    }

    @NotNull
    public Body getBody() {
        return body;
    }
}
