package ru.yandex.qe.dispenser.ws.quota.request.workflow.context;

import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.goal.Goal;
import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

@ParametersAreNonnullByDefault
public class RequestContext extends PerformerContext {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<Service> services;
    @Nullable
    private final Goal goal;
    @Nullable
    private final QuotaChangeRequest.Campaign campaign;
    @Nullable
    private final BotCampaignGroup campaignGroup;

    public RequestContext(final Person person,
                          final Project project,
                          final Set<Service> services,
                          @Nullable final Goal goal,
                          @Nullable final QuotaChangeRequest.Campaign campaign,
                          @Nullable final BotCampaignGroup campaignGroup) {
        super(person);
        this.project = project;
        this.services = services;
        this.goal = goal;
        this.campaign = campaign;
        this.campaignGroup = campaignGroup;
    }

    public RequestContext(final Person person,
                          final QuotaChangeRequest quotaChangeRequest,
                          @Nullable final Goal goal,
                          @Nullable final QuotaChangeRequest.Campaign campaign,
                          @Nullable final BotCampaignGroup campaignGroup) {
        this(person, quotaChangeRequest.getProject(), quotaChangeRequest.getChanges().stream().map(c -> c.getResource().getService()).collect(Collectors.toSet()), goal, campaign, campaignGroup);
    }

    public RequestContext(final Person person, final QuotaChangeRequest quotaChangeRequest) {
        this(person, quotaChangeRequest, null, null, null);
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    @NotNull
    public Set<Service> getServices() {
        return services;
    }

    @NotNull
    public String getServicesString() {
        return services.stream().map(NormalizedPrimaryKeyBase::getKey).collect(Collectors.joining(","));
    }

    @Nullable
    public Goal getGoal() {
        return goal;
    }

    @Nullable
    public QuotaChangeRequest.Campaign getCampaign() {
        return campaign;
    }

    @Nullable
    public BotCampaignGroup getCampaignGroup() {
        return campaignGroup;
    }
}
